@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The IIS handler mappings used to define which handler processes HTTP requests with certain extension.
 * For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension.
 * @property arguments Command-line arguments to be passed to the script processor.
 * @property extension Requests with this extension will be handled using the specified FastCGI application.
 * @property scriptProcessor The absolute path to the FastCGI application.
 */
public data class HandlerMappingResponse(
    public val arguments: String? = null,
    public val extension: String? = null,
    public val scriptProcessor: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.HandlerMappingResponse):
            HandlerMappingResponse = HandlerMappingResponse(
            arguments = javaType.arguments().map({ args0 -> args0 }).orElse(null),
            extension = javaType.extension().map({ args0 -> args0 }).orElse(null),
            scriptProcessor = javaType.scriptProcessor().map({ args0 -> args0 }).orElse(null),
        )
    }
}
