@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the paths HTTP requests.
 * @property apiPrefix The prefix that should precede all the authentication/authorization paths.
 */
public data class HttpSettingsRoutesResponse(
    public val apiPrefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.HttpSettingsRoutesResponse):
            HttpSettingsRoutesResponse = HttpSettingsRoutesResponse(
            apiPrefix = javaType.apiPrefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
