@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * IP security restriction on an app.
 * @property action Allow or Deny access for this IP range.
 * @property description IP restriction rule description.
 * @property headers IP restriction rule headers.
 * X-Forwarded-Host (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
 * The matching logic is ..
 * - If the property is null or empty (default), all hosts(or lack of) are allowed.
 * - A value is compared using ordinal-ignore-case (excluding port number).
 * - Subdomain wildcards are permitted but don't match the root domain. For example, *.contoso.com matches the subdomain foo.contoso.com
 *  but not the root domain contoso.com or multi-level foo.bar.contoso.com
 * - Unicode host names are allowed but are converted to Punycode for matching.
 * X-Forwarded-For (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
 * The matching logic is ..
 * - If the property is null or empty (default), any forwarded-for chains (or lack of) are allowed.
 * - If any address (excluding port number) in the chain (comma separated) matches the CIDR defined by the property.
 * X-Azure-FDID and X-FD-HealthProbe.
 * The matching logic is exact match.
 * @property ipAddress IP address the security restriction is valid for.
 * It can be in form of pure ipv4 address (required SubnetMask property) or
 * CIDR notation such as ipv4/mask (leading bit match). For CIDR,
 * SubnetMask property must not be specified.
 * @property name IP restriction rule name.
 * @property priority Priority of IP restriction rule.
 * @property subnetMask Subnet mask for the range of IP addresses the restriction is valid for.
 * @property subnetTrafficTag (internal) Subnet traffic tag
 * @property tag Defines what this IP filter will be used for. This is to support IP filtering on proxies.
 * @property vnetSubnetResourceId Virtual network resource id
 * @property vnetTrafficTag (internal) Vnet traffic tag
 */
public data class IpSecurityRestrictionResponse(
    public val action: String? = null,
    public val description: String? = null,
    public val headers: Map<String, List<String>>? = null,
    public val ipAddress: String? = null,
    public val name: String? = null,
    public val priority: Int? = null,
    public val subnetMask: String? = null,
    public val subnetTrafficTag: Int? = null,
    public val tag: String? = null,
    public val vnetSubnetResourceId: String? = null,
    public val vnetTrafficTag: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.IpSecurityRestrictionResponse):
            IpSecurityRestrictionResponse = IpSecurityRestrictionResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            headers = javaType.headers().map({ args0 ->
                args0.key.to(
                    args0.value.map({ args0 ->
                        args0
                    }),
                )
            }).toMap(),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            subnetMask = javaType.subnetMask().map({ args0 -> args0 }).orElse(null),
            subnetTrafficTag = javaType.subnetTrafficTag().map({ args0 -> args0 }).orElse(null),
            tag = javaType.tag().map({ args0 -> args0 }).orElse(null),
            vnetSubnetResourceId = javaType.vnetSubnetResourceId().map({ args0 -> args0 }).orElse(null),
            vnetTrafficTag = javaType.vnetTrafficTag().map({ args0 -> args0 }).orElse(null),
        )
    }
}
