@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The configuration settings of the legacy Microsoft Account provider.
 * @property enabled <code>false</code> if the legacy Microsoft Account provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property login The configuration settings of the login flow.
 * @property registration The configuration settings of the app registration for the legacy Microsoft Account provider.
 * @property validation The configuration settings of the legacy Microsoft Account provider token validation flow.
 */
public data class LegacyMicrosoftAccountResponse(
    public val enabled: Boolean? = null,
    public val login: LoginScopesResponse? = null,
    public val registration: ClientRegistrationResponse? = null,
    public val validation: AllowedAudiencesValidationResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.LegacyMicrosoftAccountResponse):
            LegacyMicrosoftAccountResponse = LegacyMicrosoftAccountResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            login = javaType.login().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.LoginScopesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            registration = javaType.registration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ClientRegistrationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            validation = javaType.validation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AllowedAudiencesValidationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
