@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Push settings for the App.
 * @property dynamicTagsJson Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
 * @property id Resource Id.
 * @property isPushEnabled Gets or sets a flag indicating whether the Push endpoint is enabled.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property tagWhitelistJson Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
 * @property tagsRequiringAuth Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
 * Tags can consist of alphanumeric characters and the following:
 * '_', '@', '#', '.', ':', '-'.
 * Validation should be performed at the PushRequestHandler.
 * @property type Resource type.
 */
public data class PushSettingsResponse(
    public val dynamicTagsJson: String? = null,
    public val id: String,
    public val isPushEnabled: Boolean,
    public val kind: String? = null,
    public val name: String,
    public val tagWhitelistJson: String? = null,
    public val tagsRequiringAuth: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.PushSettingsResponse):
            PushSettingsResponse = PushSettingsResponse(
            dynamicTagsJson = javaType.dynamicTagsJson().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isPushEnabled = javaType.isPushEnabled(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tagWhitelistJson = javaType.tagWhitelistJson().map({ args0 -> args0 }).orElse(null),
            tagsRequiringAuth = javaType.tagsRequiringAuth().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
