@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Trigger based on total requests.
 * @property count Request Count.
 * @property timeInterval Time interval.
 */
public data class RequestsBasedTriggerResponse(
    public val count: Int? = null,
    public val timeInterval: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.RequestsBasedTriggerResponse):
            RequestsBasedTriggerResponse = RequestsBasedTriggerResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            timeInterval = javaType.timeInterval().map({ args0 -> args0 }).orElse(null),
        )
    }
}
