@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Message envelope that contains the common Azure resource manager properties and the resource provider specific content.
 * @property error Azure-AsyncOperation Error info.
 * @property id Resource Id. Typically ID is populated only for responses to GET requests. Caller is responsible for passing in this
 * value for GET requests only.
 * For example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}
 * @property identity MSI resource
 * @property location Geographical region resource belongs to e.g. SouthCentralUS, SouthEastAsia.
 * @property name Name of resource.
 * @property plan Azure resource manager plan.
 * @property properties Resource specific properties.
 * @property sku SKU description of the resource.
 * @property status Azure-AsyncOperation Status info.
 * @property tags Tags associated with resource.
 * @property type Type of resource e.g "Microsoft.Web/sites".
 * @property zones Logical Availability Zones the service is hosted in
 */
public data class ResponseMessageEnvelopeRemotePrivateEndpointConnectionResponse(
    public val error: ErrorEntityResponse? = null,
    public val id: String? = null,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val location: String? = null,
    public val name: String? = null,
    public val plan: ArmPlanResponse? = null,
    public val properties: RemotePrivateEndpointConnectionResponse? = null,
    public val sku: SkuDescriptionResponse? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
    public val zones: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ResponseMessageEnvelopeRemotePrivateEndpointConnectionResponse):
            ResponseMessageEnvelopeRemotePrivateEndpointConnectionResponse =
            ResponseMessageEnvelopeRemotePrivateEndpointConnectionResponse(
                error = javaType.error().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.web.kotlin.outputs.ErrorEntityResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                identity = javaType.identity().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.web.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                location = javaType.location().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                plan = javaType.plan().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.web.kotlin.outputs.ArmPlanResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                properties = javaType.properties().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.web.kotlin.outputs.RemotePrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sku = javaType.sku().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.web.kotlin.outputs.SkuDescriptionResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
                zones = javaType.zones().map({ args0 -> args0 }),
            )
    }
}
