@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Container App container scaling rule.
 * @property azureQueue Azure Queue based scaling.
 * @property custom Custom scale rule.
 * @property http HTTP requests based scaling.
 * @property name Scale Rule Name
 */
public data class ScaleRuleResponse(
    public val azureQueue: QueueScaleRuleResponse? = null,
    public val custom: CustomScaleRuleResponse? = null,
    public val http: HttpScaleRuleResponse? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ScaleRuleResponse):
            ScaleRuleResponse = ScaleRuleResponse(
            azureQueue = javaType.azureQueue().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.QueueScaleRuleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            custom = javaType.custom().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.CustomScaleRuleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            http = javaType.http().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.HttpScaleRuleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
