@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Description of the App Service plan scale options.
 * @property default Default number of workers for this App Service plan SKU.
 * @property elasticMaximum Maximum number of Elastic workers for this App Service plan SKU.
 * @property maximum Maximum number of workers for this App Service plan SKU.
 * @property minimum Minimum number of workers for this App Service plan SKU.
 * @property scaleType Available scale configurations for an App Service plan.
 */
public data class SkuCapacityResponse(
    public val default: Int? = null,
    public val elasticMaximum: Int? = null,
    public val maximum: Int? = null,
    public val minimum: Int? = null,
    public val scaleType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.SkuCapacityResponse):
            SkuCapacityResponse = SkuCapacityResponse(
            default = javaType.default_().map({ args0 -> args0 }).orElse(null),
            elasticMaximum = javaType.elasticMaximum().map({ args0 -> args0 }).orElse(null),
            maximum = javaType.maximum().map({ args0 -> args0 }).orElse(null),
            minimum = javaType.minimum().map({ args0 -> args0 }).orElse(null),
            scaleType = javaType.scaleType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
