@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Template Options for the static site.
 * @property description Description of the newly generated repository.
 * @property isPrivate Whether or not the newly generated repository is a private repository. Defaults to false (i.e. public).
 * @property owner Owner of the newly generated repository.
 * @property repositoryName Name of the newly generated repository.
 * @property templateRepositoryUrl URL of the template repository. The newly generated repository will be based on this one.
 */
public data class StaticSiteTemplateOptionsResponse(
    public val description: String? = null,
    public val isPrivate: Boolean? = null,
    public val owner: String? = null,
    public val repositoryName: String? = null,
    public val templateRepositoryUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.StaticSiteTemplateOptionsResponse):
            StaticSiteTemplateOptionsResponse = StaticSiteTemplateOptionsResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            isPrivate = javaType.isPrivate().map({ args0 -> args0 }).orElse(null),
            owner = javaType.owner().map({ args0 -> args0 }).orElse(null),
            repositoryName = javaType.repositoryName().map({ args0 -> args0 }).orElse(null),
            templateRepositoryUrl = javaType.templateRepositoryUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
