@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Static Site User ARM resource.
 * @property displayName The display name for the static site user.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property provider The identity provider for the static site user.
 * @property roles The roles for the static site user, in free-form string format
 * @property type Resource type.
 * @property userId The user id for the static site user.
 */
public data class StaticSiteUserARMResourceResponse(
    public val displayName: String,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val provider: String,
    public val roles: String? = null,
    public val type: String,
    public val userId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.StaticSiteUserARMResourceResponse):
            StaticSiteUserARMResourceResponse = StaticSiteUserARMResourceResponse(
            displayName = javaType.displayName(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provider = javaType.provider(),
            roles = javaType.roles().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userId = javaType.userId(),
        )
    }
}
