@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress

/**
 * The configuration settings of the token store.
 * @property azureBlobStorage The configuration settings of the storage of the tokens if blob storage is used.
 * @property enabled <code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.
 *  The default is <code>false</code>.
 * @property fileSystem The configuration settings of the storage of the tokens if a file system is used.
 * @property tokenRefreshExtensionHours The number of hours after session token expiration that a session token can be used to
 * call the token refresh API. The default is 72 hours.
 */
public data class TokenStoreResponse(
    public val azureBlobStorage: BlobStorageTokenStoreResponse? = null,
    public val enabled: Boolean? = null,
    public val fileSystem: FileSystemTokenStoreResponse? = null,
    public val tokenRefreshExtensionHours: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.TokenStoreResponse):
            TokenStoreResponse = TokenStoreResponse(
            azureBlobStorage = javaType.azureBlobStorage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.BlobStorageTokenStoreResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            fileSystem = javaType.fileSystem().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.FileSystemTokenStoreResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tokenRefreshExtensionHours = javaType.tokenRefreshExtensionHours().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
