@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin

import com.pulumi.azurenative.webpubsub.WebPubSubReplicaArgs.builder
import com.pulumi.azurenative.webpubsub.kotlin.inputs.ResourceSkuArgs
import com.pulumi.azurenative.webpubsub.kotlin.inputs.ResourceSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A class represent a replica resource.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### WebPubSubReplicas_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webPubSubReplica = new AzureNative.WebPubSub.WebPubSubReplica("webPubSubReplica", new()
 *     {
 *         Location = "eastus",
 *         ReplicaName = "myWebPubSubService-eastus",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "myWebPubSubService",
 *         Sku = new AzureNative.WebPubSub.Inputs.ResourceSkuArgs
 *         {
 *             Capacity = 1,
 *             Name = "Premium_P1",
 *             Tier = "Premium",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/webpubsub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := webpubsub.NewWebPubSubReplica(ctx, "webPubSubReplica", &webpubsub.WebPubSubReplicaArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			ReplicaName:       pulumi.String("myWebPubSubService-eastus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("myWebPubSubService"),
 * 			Sku: &webpubsub.ResourceSkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Premium_P1"),
 * 				Tier:     pulumi.String("Premium"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.webpubsub.WebPubSubReplica;
 * import com.pulumi.azurenative.webpubsub.WebPubSubReplicaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webPubSubReplica = new WebPubSubReplica("webPubSubReplica", WebPubSubReplicaArgs.builder()
 *             .location("eastus")
 *             .replicaName("myWebPubSubService-eastus")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("myWebPubSubService")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "Premium_P1"),
 *                 Map.entry("tier", "Premium")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:webpubsub:WebPubSubReplica myWebPubSubService-eastus /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/webPubSub/{resourceName}/replicas/{replicaName}
 * ```
 * @property location The geo-location where the resource lives
 * @property replicaName The name of the replica.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the resource.
 * @property sku The billing information of the resource.
 * @property tags Resource tags.
 */
public data class WebPubSubReplicaArgs(
    public val location: Output<String>? = null,
    public val replicaName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val sku: Output<ResourceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.WebPubSubReplicaArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.WebPubSubReplicaArgs =
        com.pulumi.azurenative.webpubsub.WebPubSubReplicaArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .replicaName(replicaName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [WebPubSubReplicaArgs].
 */
@PulumiTagMarker
public class WebPubSubReplicaArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var replicaName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var sku: Output<ResourceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("iylfuyyafhjepjtf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the replica.
     */
    @JvmName("rqijfryhnxgxsuif")
    public suspend fun replicaName(`value`: Output<String>) {
        this.replicaName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("htbtlvwlxjigieue")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("wpkgjkbxluvdxgde")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The billing information of the resource.
     */
    @JvmName("daglneoefcllceeo")
    public suspend fun sku(`value`: Output<ResourceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aiafnnlvpcexpefr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mrrmqomhffwdrxpu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the replica.
     */
    @JvmName("pgwnehlrudruhuvi")
    public suspend fun replicaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ppanoljobtaxuxbq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("wjdjxbhsdtyrfldx")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The billing information of the resource.
     */
    @JvmName("nvxcykoxlkxpwutl")
    public suspend fun sku(`value`: ResourceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The billing information of the resource.
     */
    @JvmName("sfgmyjvvusynmfvg")
    public suspend fun sku(argument: suspend ResourceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dhcuaaabowhdlbtf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("justlrqyslbobjse")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WebPubSubReplicaArgs = WebPubSubReplicaArgs(
        location = location,
        replicaName = replicaName,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        sku = sku,
        tags = tags,
    )
}
