@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.inputs

import com.pulumi.azurenative.webpubsub.inputs.EventListenerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A setting defines which kinds of events should be sent to which endpoint.
 * @property endpoint An endpoint specifying where Web PubSub should send events to.
 * @property filter A base class for event filter which determines whether an event should be sent to an event listener.
 */
public data class EventListenerArgs(
    public val endpoint: Output<EventHubEndpointArgs>,
    public val filter: Output<EventNameFilterArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.inputs.EventListenerArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.inputs.EventListenerArgs =
        com.pulumi.azurenative.webpubsub.inputs.EventListenerArgs.builder()
            .endpoint(endpoint.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filter(filter.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EventListenerArgs].
 */
@PulumiTagMarker
public class EventListenerArgsBuilder internal constructor() {
    private var endpoint: Output<EventHubEndpointArgs>? = null

    private var filter: Output<EventNameFilterArgs>? = null

    /**
     * @param value An endpoint specifying where Web PubSub should send events to.
     */
    @JvmName("clbdvmxuocjmtsds")
    public suspend fun endpoint(`value`: Output<EventHubEndpointArgs>) {
        this.endpoint = value
    }

    /**
     * @param value A base class for event filter which determines whether an event should be sent to an event listener.
     */
    @JvmName("ktmvuvkiaogdfswk")
    public suspend fun filter(`value`: Output<EventNameFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value An endpoint specifying where Web PubSub should send events to.
     */
    @JvmName("kpkildcrvannjodi")
    public suspend fun endpoint(`value`: EventHubEndpointArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param argument An endpoint specifying where Web PubSub should send events to.
     */
    @JvmName("nweolvogsjggtedq")
    public suspend fun endpoint(argument: suspend EventHubEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = EventHubEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpoint = mapped
    }

    /**
     * @param value A base class for event filter which determines whether an event should be sent to an event listener.
     */
    @JvmName("nexfthpmlmlkccnm")
    public suspend fun filter(`value`: EventNameFilterArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument A base class for event filter which determines whether an event should be sent to an event listener.
     */
    @JvmName("eterdbmqwaxfchri")
    public suspend fun filter(argument: suspend EventNameFilterArgsBuilder.() -> Unit) {
        val toBeMapped = EventNameFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    internal fun build(): EventListenerArgs = EventListenerArgs(
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        filter = filter ?: throw PulumiNullFieldException("filter"),
    )
}
