@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.windowsesu.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [MultipleActivationKey].
 */
@PulumiTagMarker
public class MultipleActivationKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MultipleActivationKeyArgs = MultipleActivationKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MultipleActivationKeyArgsBuilder.() -> Unit) {
        val builder = MultipleActivationKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MultipleActivationKey {
        val builtJavaResource =
            com.pulumi.azurenative.windowsesu.MultipleActivationKey(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MultipleActivationKey(builtJavaResource)
    }
}

/**
 * MAK key details.
 * Azure REST API version: 2019-09-16-preview. Prior API version in Azure Native 1.x: 2019-09-16-preview.
 * ## Example Usage
 * ### CreateMultipleActivationKey
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var multipleActivationKey = new AzureNative.WindowsESU.MultipleActivationKey("multipleActivationKey", new()
 *     {
 *         AgreementNumber = "1a2b45ag",
 *         InstalledServerNumber = 100,
 *         IsEligible = true,
 *         Location = "East US",
 *         MultipleActivationKeyName = "server08-key-2019",
 *         OsType = "WindowsServer2008",
 *         ResourceGroupName = "testgr1",
 *         SupportType = "SupplementalServicing",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/windowsesu/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := windowsesu.NewMultipleActivationKey(ctx, "multipleActivationKey", &windowsesu.MultipleActivationKeyArgs{
 * 			AgreementNumber:           pulumi.String("1a2b45ag"),
 * 			InstalledServerNumber:     pulumi.Int(100),
 * 			IsEligible:                pulumi.Bool(true),
 * 			Location:                  pulumi.String("East US"),
 * 			MultipleActivationKeyName: pulumi.String("server08-key-2019"),
 * 			OsType:                    pulumi.String("WindowsServer2008"),
 * 			ResourceGroupName:         pulumi.String("testgr1"),
 * 			SupportType:               pulumi.String("SupplementalServicing"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.windowsesu.MultipleActivationKey;
 * import com.pulumi.azurenative.windowsesu.MultipleActivationKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var multipleActivationKey = new MultipleActivationKey("multipleActivationKey", MultipleActivationKeyArgs.builder()
 *             .agreementNumber("1a2b45ag")
 *             .installedServerNumber(100)
 *             .isEligible(true)
 *             .location("East US")
 *             .multipleActivationKeyName("server08-key-2019")
 *             .osType("WindowsServer2008")
 *             .resourceGroupName("testgr1")
 *             .supportType("SupplementalServicing")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:windowsesu:MultipleActivationKey server08-key-2019 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.WindowsESU/multipleActivationKeys/{multipleActivationKeyName}
 * ```
 */
public class MultipleActivationKey internal constructor(
    override val javaResource: com.pulumi.azurenative.windowsesu.MultipleActivationKey,
) : KotlinCustomResource(javaResource, MultipleActivationKeyMapper) {
    /**
     * Agreement number under which the key is requested.
     */
    public val agreementNumber: Output<String>?
        get() = javaResource.agreementNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * End of support of security updates activated by the MAK key.
     */
    public val expirationDate: Output<String>
        get() = javaResource.expirationDate().applyValue({ args0 -> args0 })

    /**
     * Number of activations/servers using the MAK key.
     */
    public val installedServerNumber: Output<Int>?
        get() = javaResource.installedServerNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * <code> true </code> if user has eligible on-premises Windows physical or virtual machines, and that the requested key will only be used in their organization; <code> false </code> otherwise.
     */
    public val isEligible: Output<Boolean>?
        get() = javaResource.isEligible().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * MAK 5x5 key.
     */
    public val multipleActivationKey: Output<String>
        get() = javaResource.multipleActivationKey().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Type of OS for which the key is requested.
     */
    public val osType: Output<String>?
        get() = javaResource.osType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Type of support
     */
    public val supportType: Output<String>?
        get() = javaResource.supportType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MultipleActivationKeyMapper : ResourceMapper<MultipleActivationKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.windowsesu.MultipleActivationKey::class == javaResource::class

    override fun map(javaResource: Resource): MultipleActivationKey =
        MultipleActivationKey(javaResource as com.pulumi.azurenative.windowsesu.MultipleActivationKey)
}

/**
 * @see [MultipleActivationKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MultipleActivationKey].
 */
public suspend fun multipleActivationKey(
    name: String,
    block: suspend MultipleActivationKeyResourceBuilder.() -> Unit,
): MultipleActivationKey {
    val builder = MultipleActivationKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MultipleActivationKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun multipleActivationKey(name: String): MultipleActivationKey {
    val builder = MultipleActivationKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
