@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.windowsesu.kotlin.inputs

import com.pulumi.azurenative.windowsesu.inputs.GetMultipleActivationKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property multipleActivationKeyName The name of the MAK key.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMultipleActivationKeyPlainArgs(
    public val multipleActivationKeyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.windowsesu.inputs.GetMultipleActivationKeyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.windowsesu.inputs.GetMultipleActivationKeyPlainArgs =
        com.pulumi.azurenative.windowsesu.inputs.GetMultipleActivationKeyPlainArgs.builder()
            .multipleActivationKeyName(multipleActivationKeyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMultipleActivationKeyPlainArgs].
 */
@PulumiTagMarker
public class GetMultipleActivationKeyPlainArgsBuilder internal constructor() {
    private var multipleActivationKeyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the MAK key.
     */
    @JvmName("eukdlhmokvjywqbd")
    public suspend fun multipleActivationKeyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.multipleActivationKeyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("etujifytkvgciuvi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMultipleActivationKeyPlainArgs = GetMultipleActivationKeyPlainArgs(
        multipleActivationKeyName = multipleActivationKeyName ?: throw
            PulumiNullFieldException("multipleActivationKeyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
