@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Define the backup connection resource of virtual instance for SAP..
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### Create a HANA backup connection with a new backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.HanaBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.DBBackupPolicyPropertiesArgs
 *             {
 *                 BackupManagementType = "AzureWorkload",
 *                 Name = "defaultHanaPolicy",
 *                 ProtectedItemsCount = 0,
 *                 Settings = new AzureNative.Workloads.Inputs.SettingsArgs
 *                 {
 *                     IsCompression = false,
 *                     Issqlcompression = false,
 *                     TimeZone = "UTC",
 *                 },
 *                 SubProtectionPolicy = new[]
 *                 {
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = "Full",
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.LongTermRetentionPolicyArgs
 *                         {
 *                             MonthlySchedule = new AzureNative.Workloads.Inputs.MonthlyRetentionScheduleArgs
 *                             {
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 60,
 *                                     DurationType = "Months",
 *                                 },
 *                                 RetentionScheduleFormatType = "Weekly",
 *                                 RetentionScheduleWeekly = new AzureNative.Workloads.Inputs.WeeklyRetentionFormatArgs
 *                                 {
 *                                     DaysOfTheWeek = new[]
 *                                     {
 *                                         AzureNative.Workloads.DayOfWeek.Sunday,
 *                                     },
 *                                     WeeksOfTheMonth = new[]
 *                                     {
 *                                         AzureNative.Workloads.WeekOfMonth.First,
 *                                     },
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2022-11-29T19:30:00.000Z",
 *                                 },
 *                             },
 *                             RetentionPolicyType = "LongTermRetentionPolicy",
 *                             WeeklySchedule = new AzureNative.Workloads.Inputs.WeeklyRetentionScheduleArgs
 *                             {
 *                                 DaysOfTheWeek = new[]
 *                                 {
 *                                     AzureNative.Workloads.DayOfWeek.Sunday,
 *                                 },
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 104,
 *                                     DurationType = "Weeks",
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2022-11-29T19:30:00.000Z",
 *                                 },
 *                             },
 *                             YearlySchedule = new AzureNative.Workloads.Inputs.YearlyRetentionScheduleArgs
 *                             {
 *                                 MonthsOfYear = new[]
 *                                 {
 *                                     AzureNative.Workloads.MonthOfYear.January,
 *                                 },
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 10,
 *                                     DurationType = "Years",
 *                                 },
 *                                 RetentionScheduleFormatType = "Weekly",
 *                                 RetentionScheduleWeekly = new AzureNative.Workloads.Inputs.WeeklyRetentionFormatArgs
 *                                 {
 *                                     DaysOfTheWeek = new[]
 *                                     {
 *                                         AzureNative.Workloads.DayOfWeek.Sunday,
 *                                     },
 *                                     WeeksOfTheMonth = new[]
 *                                     {
 *                                         AzureNative.Workloads.WeekOfMonth.First,
 *                                     },
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2022-11-29T19:30:00.000Z",
 *                                 },
 *                             },
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                         {
 *                             SchedulePolicyType = "SimpleSchedulePolicy",
 *                             ScheduleRunDays = new[]
 *                             {
 *                                 AzureNative.Workloads.DayOfWeek.Sunday,
 *                             },
 *                             ScheduleRunFrequency = "Weekly",
 *                             ScheduleRunTimes = new[]
 *                             {
 *                                 "2022-11-29T19:30:00.000Z",
 *                             },
 *                         },
 *                         TieringPolicy =
 *                         {
 *                             { "ArchivedRP", new AzureNative.Workloads.Inputs.TieringPolicyArgs
 *                             {
 *                                 TieringMode = "DoNotTier",
 *                             } },
 *                         },
 *                     },
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = "Differential",
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.SimpleRetentionPolicyArgs
 *                         {
 *                             RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 30,
 *                                 DurationType = "Days",
 *                             },
 *                             RetentionPolicyType = "SimpleRetentionPolicy",
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                         {
 *                             SchedulePolicyType = "SimpleSchedulePolicy",
 *                             ScheduleRunDays = new[]
 *                             {
 *                                 AzureNative.Workloads.DayOfWeek.Monday,
 *                             },
 *                             ScheduleRunFrequency = "Weekly",
 *                             ScheduleRunTimes = new[]
 *                             {
 *                                 "2022-09-29T02:00:00Z",
 *                             },
 *                             ScheduleWeeklyFrequency = 0,
 *                         },
 *                     },
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = "Log",
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.SimpleRetentionPolicyArgs
 *                         {
 *                             RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 20,
 *                                 DurationType = "Days",
 *                             },
 *                             RetentionPolicyType = "SimpleRetentionPolicy",
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.LogSchedulePolicyArgs
 *                         {
 *                             ScheduleFrequencyInMins = 120,
 *                             SchedulePolicyType = "LogSchedulePolicy",
 *                         },
 *                     },
 *                 },
 *                 WorkLoadType = "SAPHanaDatabase",
 *             },
 *             BackupType = "HANA",
 *             DbInstanceSnapshotBackupPolicy = new AzureNative.Workloads.Inputs.DBBackupPolicyPropertiesArgs
 *             {
 *                 BackupManagementType = "AzureWorkload",
 *                 Name = "defaultDbInstanceSnapshotPolicy",
 *                 Settings = new AzureNative.Workloads.Inputs.SettingsArgs
 *                 {
 *                     IsCompression = false,
 *                     Issqlcompression = false,
 *                     TimeZone = "UTC",
 *                 },
 *                 SubProtectionPolicy = new[]
 *                 {
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = "SnapshotFull",
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                         {
 *                             SchedulePolicyType = "SimpleSchedulePolicy",
 *                             ScheduleRunFrequency = "Daily",
 *                             ScheduleRunTimes = new[]
 *                             {
 *                                 "2023-09-18T06:30:00.000Z",
 *                             },
 *                         },
 *                         SnapshotBackupAdditionalDetails = new AzureNative.Workloads.Inputs.SnapshotBackupAdditionalDetailsArgs
 *                         {
 *                             InstantRPDetails = "test-rg",
 *                             InstantRpRetentionRangeInDays = 1,
 *                             UserAssignedManagedIdentityDetails = new AzureNative.Workloads.Inputs.UserAssignedManagedIdentityDetailsArgs
 *                             {
 *                                 IdentityArmId = "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourcegroups/test-rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testMsi",
 *                                 IdentityName = "testMsi",
 *                                 UserAssignedIdentityProperties = new AzureNative.Workloads.Inputs.UserAssignedIdentityPropertiesArgs
 *                                 {
 *                                     ClientId = "c3a877cf-51f8-4031-8f17-ab562d1e7737",
 *                                     PrincipalId = "2f5834bd-4b86-4d85-a8df-6dd829a6418c",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *                 WorkLoadType = "SAPHanaDBInstance",
 *             },
 *             HdbuserstoreKeyName = "abcd",
 *             InstanceNumber = "00",
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.NewRecoveryServicesVaultArgs
 *             {
 *                 Name = "test-vault",
 *                 ResourceGroup = "test-rg",
 *                 VaultType = "New",
 *             },
 *             SslConfiguration = new AzureNative.Workloads.Inputs.SSLConfigurationArgs
 *             {
 *                 SslCryptoProvider = "commoncrypto",
 *                 SslHostNameInCertificate = "hostname",
 *                 SslKeyStore = "sapsrv.pse",
 *                 SslTrustStore = "sapsrv.pse",
 *             },
 *         },
 *         BackupName = "dbBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * 			BackupData: workloads.HanaBackupData{
 * 				BackupPolicy: workloads.DBBackupPolicyProperties{
 * 					BackupManagementType: "AzureWorkload",
 * 					Name:                 "defaultHanaPolicy",
 * 					ProtectedItemsCount:  0,
 * 					Settings: workloads.Settings{
 * 						IsCompression:    false,
 * 						Issqlcompression: false,
 * 						TimeZone:         "UTC",
 * 					},
 * 					SubProtectionPolicy: []workloads.SubProtectionPolicy{
 * 						{
 * 							PolicyType: "Full",
 * 							RetentionPolicy: {
 * 								MonthlySchedule: {
 * 									RetentionDuration: {
 * 										Count:        60,
 * 										DurationType: "Months",
 * 									},
 * 									RetentionScheduleFormatType: "Weekly",
 * 									RetentionScheduleWeekly: {
 * 										DaysOfTheWeek: []workloads.DayOfWeek{
 * 											workloads.DayOfWeekSunday,
 * 										},
 * 										WeeksOfTheMonth: []workloads.WeekOfMonth{
 * 											workloads.WeekOfMonthFirst,
 * 										},
 * 									},
 * 									RetentionTimes: []string{
 * 										"2022-11-29T19:30:00.000Z",
 * 									},
 * 								},
 * 								RetentionPolicyType: "LongTermRetentionPolicy",
 * 								WeeklySchedule: {
 * 									DaysOfTheWeek: []workloads.DayOfWeek{
 * 										workloads.DayOfWeekSunday,
 * 									},
 * 									RetentionDuration: {
 * 										Count:        104,
 * 										DurationType: "Weeks",
 * 									},
 * 									RetentionTimes: []string{
 * 										"2022-11-29T19:30:00.000Z",
 * 									},
 * 								},
 * 								YearlySchedule: {
 * 									MonthsOfYear: []workloads.MonthOfYear{
 * 										workloads.MonthOfYearJanuary,
 * 									},
 * 									RetentionDuration: {
 * 										Count:        10,
 * 										DurationType: "Years",
 * 									},
 * 									RetentionScheduleFormatType: "Weekly",
 * 									RetentionScheduleWeekly: {
 * 										DaysOfTheWeek: []workloads.DayOfWeek{
 * 											workloads.DayOfWeekSunday,
 * 										},
 * 										WeeksOfTheMonth: []workloads.WeekOfMonth{
 * 											workloads.WeekOfMonthFirst,
 * 										},
 * 									},
 * 									RetentionTimes: []string{
 * 										"2022-11-29T19:30:00.000Z",
 * 									},
 * 								},
 * 							},
 * 							SchedulePolicy: {
 * 								SchedulePolicyType: "SimpleSchedulePolicy",
 * 								ScheduleRunDays: []workloads.DayOfWeek{
 * 									workloads.DayOfWeekSunday,
 * 								},
 * 								ScheduleRunFrequency: "Weekly",
 * 								ScheduleRunTimes: []string{
 * 									"2022-11-29T19:30:00.000Z",
 * 								},
 * 							},
 * 							TieringPolicy: {
 * 								ArchivedRP: {
 * 									TieringMode: "DoNotTier",
 * 								},
 * 							},
 * 						},
 * 						{
 * 							PolicyType: "Differential",
 * 							RetentionPolicy: {
 * 								RetentionDuration: {
 * 									Count:        30,
 * 									DurationType: "Days",
 * 								},
 * 								RetentionPolicyType: "SimpleRetentionPolicy",
 * 							},
 * 							SchedulePolicy: {
 * 								SchedulePolicyType: "SimpleSchedulePolicy",
 * 								ScheduleRunDays: []workloads.DayOfWeek{
 * 									workloads.DayOfWeekMonday,
 * 								},
 * 								ScheduleRunFrequency: "Weekly",
 * 								ScheduleRunTimes: []string{
 * 									"2022-09-29T02:00:00Z",
 * 								},
 * 								ScheduleWeeklyFrequency: 0,
 * 							},
 * 						},
 * 						{
 * 							PolicyType: "Log",
 * 							RetentionPolicy: {
 * 								RetentionDuration: {
 * 									Count:        20,
 * 									DurationType: "Days",
 * 								},
 * 								RetentionPolicyType: "SimpleRetentionPolicy",
 * 							},
 * 							SchedulePolicy: {
 * 								ScheduleFrequencyInMins: 120,
 * 								SchedulePolicyType:      "LogSchedulePolicy",
 * 							},
 * 						},
 * 					},
 * 					WorkLoadType: "SAPHanaDatabase",
 * 				},
 * 				BackupType: "HANA",
 * 				DbInstanceSnapshotBackupPolicy: workloads.DBBackupPolicyProperties{
 * 					BackupManagementType: "AzureWorkload",
 * 					Name:                 "defaultDbInstanceSnapshotPolicy",
 * 					Settings: workloads.Settings{
 * 						IsCompression:    false,
 * 						Issqlcompression: false,
 * 						TimeZone:         "UTC",
 * 					},
 * 					SubProtectionPolicy: []workloads.SubProtectionPolicy{
 * 						{
 * 							PolicyType: "SnapshotFull",
 * 							SchedulePolicy: {
 * 								SchedulePolicyType:   "SimpleSchedulePolicy",
 * 								ScheduleRunFrequency: "Daily",
 * 								ScheduleRunTimes: []string{
 * 									"2023-09-18T06:30:00.000Z",
 * 								},
 * 							},
 * 							SnapshotBackupAdditionalDetails: {
 * 								InstantRPDetails:              "test-rg",
 * 								InstantRpRetentionRangeInDays: 1,
 * 								UserAssignedManagedIdentityDetails: {
 * 									IdentityArmId: "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourcegroups/test-rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testMsi",
 * 									IdentityName:  "testMsi",
 * 									UserAssignedIdentityProperties: {
 * 										ClientId:    "c3a877cf-51f8-4031-8f17-ab562d1e7737",
 * 										PrincipalId: "2f5834bd-4b86-4d85-a8df-6dd829a6418c",
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 					WorkLoadType: "SAPHanaDBInstance",
 * 				},
 * 				HdbuserstoreKeyName: "abcd",
 * 				InstanceNumber:      "00",
 * 				RecoveryServicesVault: workloads.NewRecoveryServicesVault{
 * 					Name:          "test-vault",
 * 					ResourceGroup: "test-rg",
 * 					VaultType:     "New",
 * 				},
 * 				SslConfiguration: workloads.SSLConfiguration{
 * 					SslCryptoProvider:        "commoncrypto",
 * 					SslHostNameInCertificate: "hostname",
 * 					SslKeyStore:              "sapsrv.pse",
 * 					SslTrustStore:            "sapsrv.pse",
 * 				},
 * 			},
 * 			BackupName:        pulumi.String("dbBackup"),
 * 			ConnectorName:     pulumi.String("C1"),
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(Map.ofEntries(
 *                 Map.entry("backupPolicy", Map.ofEntries(
 *                     Map.entry("backupManagementType", "AzureWorkload"),
 *                     Map.entry("name", "defaultHanaPolicy"),
 *                     Map.entry("protectedItemsCount", 0),
 *                     Map.entry("settings", Map.ofEntries(
 *                         Map.entry("isCompression", false),
 *                         Map.entry("issqlcompression", false),
 *                         Map.entry("timeZone", "UTC")
 *                     )),
 *                     Map.entry("subProtectionPolicy",
 *                         Map.ofEntries(
 *                             Map.entry("policyType", "Full"),
 *                             Map.entry("retentionPolicy", Map.ofEntries(
 *                                 Map.entry("monthlySchedule", Map.ofEntries(
 *                                     Map.entry("retentionDuration", Map.ofEntries(
 *                                         Map.entry("count", 60),
 *                                         Map.entry("durationType", "Months")
 *                                     )),
 *                                     Map.entry("retentionScheduleFormatType", "Weekly"),
 *                                     Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                                         Map.entry("daysOfTheWeek", "Sunday"),
 *                                         Map.entry("weeksOfTheMonth", "First")
 *                                     )),
 *                                     Map.entry("retentionTimes", "2022-11-29T19:30:00.000Z")
 *                                 )),
 *                                 Map.entry("retentionPolicyType", "LongTermRetentionPolicy"),
 *                                 Map.entry("weeklySchedule", Map.ofEntries(
 *                                     Map.entry("daysOfTheWeek", "Sunday"),
 *                                     Map.entry("retentionDuration", Map.ofEntries(
 *                                         Map.entry("count", 104),
 *                                         Map.entry("durationType", "Weeks")
 *                                     )),
 *                                     Map.entry("retentionTimes", "2022-11-29T19:30:00.000Z")
 *                                 )),
 *                                 Map.entry("yearlySchedule", Map.ofEntries(
 *                                     Map.entry("monthsOfYear", "January"),
 *                                     Map.entry("retentionDuration", Map.ofEntries(
 *                                         Map.entry("count", 10),
 *                                         Map.entry("durationType", "Years")
 *                                     )),
 *                                     Map.entry("retentionScheduleFormatType", "Weekly"),
 *                                     Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                                         Map.entry("daysOfTheWeek", "Sunday"),
 *                                         Map.entry("weeksOfTheMonth", "First")
 *                                     )),
 *                                     Map.entry("retentionTimes", "2022-11-29T19:30:00.000Z")
 *                                 ))
 *                             )),
 *                             Map.entry("schedulePolicy", Map.ofEntries(
 *                                 Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                                 Map.entry("scheduleRunDays", "Sunday"),
 *                                 Map.entry("scheduleRunFrequency", "Weekly"),
 *                                 Map.entry("scheduleRunTimes", "2022-11-29T19:30:00.000Z")
 *                             )),
 *                             Map.entry("tieringPolicy", Map.of("ArchivedRP", Map.of("tieringMode", "DoNotTier")))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("policyType", "Differential"),
 *                             Map.entry("retentionPolicy", Map.ofEntries(
 *                                 Map.entry("retentionDuration", Map.ofEntries(
 *                                     Map.entry("count", 30),
 *                                     Map.entry("durationType", "Days")
 *                                 )),
 *                                 Map.entry("retentionPolicyType", "SimpleRetentionPolicy")
 *                             )),
 *                             Map.entry("schedulePolicy", Map.ofEntries(
 *                                 Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                                 Map.entry("scheduleRunDays", "Monday"),
 *                                 Map.entry("scheduleRunFrequency", "Weekly"),
 *                                 Map.entry("scheduleRunTimes", "2022-09-29T02:00:00Z"),
 *                                 Map.entry("scheduleWeeklyFrequency", 0)
 *                             ))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("policyType", "Log"),
 *                             Map.entry("retentionPolicy", Map.ofEntries(
 *                                 Map.entry("retentionDuration", Map.ofEntries(
 *                                     Map.entry("count", 20),
 *                                     Map.entry("durationType", "Days")
 *                                 )),
 *                                 Map.entry("retentionPolicyType", "SimpleRetentionPolicy")
 *                             )),
 *                             Map.entry("schedulePolicy", Map.ofEntries(
 *                                 Map.entry("scheduleFrequencyInMins", 120),
 *                                 Map.entry("schedulePolicyType", "LogSchedulePolicy")
 *                             ))
 *                         )),
 *                     Map.entry("workLoadType", "SAPHanaDatabase")
 *                 )),
 *                 Map.entry("backupType", "HANA"),
 *                 Map.entry("dbInstanceSnapshotBackupPolicy", Map.ofEntries(
 *                     Map.entry("backupManagementType", "AzureWorkload"),
 *                     Map.entry("name", "defaultDbInstanceSnapshotPolicy"),
 *                     Map.entry("settings", Map.ofEntries(
 *                         Map.entry("isCompression", false),
 *                         Map.entry("issqlcompression", false),
 *                         Map.entry("timeZone", "UTC")
 *                     )),
 *                     Map.entry("subProtectionPolicy", Map.ofEntries(
 *                         Map.entry("policyType", "SnapshotFull"),
 *                         Map.entry("schedulePolicy", Map.ofEntries(
 *                             Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                             Map.entry("scheduleRunFrequency", "Daily"),
 *                             Map.entry("scheduleRunTimes", "2023-09-18T06:30:00.000Z")
 *                         )),
 *                         Map.entry("snapshotBackupAdditionalDetails", Map.ofEntries(
 *                             Map.entry("instantRPDetails", "test-rg"),
 *                             Map.entry("instantRpRetentionRangeInDays", 1),
 *                             Map.entry("userAssignedManagedIdentityDetails", Map.ofEntries(
 *                                 Map.entry("identityArmId", "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourcegroups/test-rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testMsi"),
 *                                 Map.entry("identityName", "testMsi"),
 *                                 Map.entry("userAssignedIdentityProperties", Map.ofEntries(
 *                                     Map.entry("clientId", "c3a877cf-51f8-4031-8f17-ab562d1e7737"),
 *                                     Map.entry("principalId", "2f5834bd-4b86-4d85-a8df-6dd829a6418c")
 *                                 ))
 *                             ))
 *                         ))
 *                     )),
 *                     Map.entry("workLoadType", "SAPHanaDBInstance")
 *                 )),
 *                 Map.entry("hdbuserstoreKeyName", "abcd"),
 *                 Map.entry("instanceNumber", "00"),
 *                 Map.entry("recoveryServicesVault", Map.ofEntries(
 *                     Map.entry("name", "test-vault"),
 *                     Map.entry("resourceGroup", "test-rg"),
 *                     Map.entry("vaultType", "New")
 *                 )),
 *                 Map.entry("sslConfiguration", Map.ofEntries(
 *                     Map.entry("sslCryptoProvider", "commoncrypto"),
 *                     Map.entry("sslHostNameInCertificate", "hostname"),
 *                     Map.entry("sslKeyStore", "sapsrv.pse"),
 *                     Map.entry("sslTrustStore", "sapsrv.pse")
 *                 ))
 *             ))
 *             .backupName("dbBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a SQL backup connection with a new backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.SqlBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.DBBackupPolicyPropertiesArgs
 *             {
 *                 BackupManagementType = "AzureWorkload",
 *                 Name = "defaultSqlPolicy",
 *                 ProtectedItemsCount = 0,
 *                 Settings = new AzureNative.Workloads.Inputs.SettingsArgs
 *                 {
 *                     IsCompression = true,
 *                     Issqlcompression = true,
 *                     TimeZone = "UTC",
 *                 },
 *                 SubProtectionPolicy = new[]
 *                 {
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = "Full",
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.LongTermRetentionPolicyArgs
 *                         {
 *                             MonthlySchedule = new AzureNative.Workloads.Inputs.MonthlyRetentionScheduleArgs
 *                             {
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 60,
 *                                     DurationType = "Months",
 *                                 },
 *                                 RetentionScheduleFormatType = "Weekly",
 *                                 RetentionScheduleWeekly = new AzureNative.Workloads.Inputs.WeeklyRetentionFormatArgs
 *                                 {
 *                                     DaysOfTheWeek = new[]
 *                                     {
 *                                         AzureNative.Workloads.DayOfWeek.Sunday,
 *                                     },
 *                                     WeeksOfTheMonth = new[]
 *                                     {
 *                                         AzureNative.Workloads.WeekOfMonth.First,
 *                                     },
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2022-11-29T19:30:00.000Z",
 *                                 },
 *                             },
 *                             RetentionPolicyType = "LongTermRetentionPolicy",
 *                             WeeklySchedule = new AzureNative.Workloads.Inputs.WeeklyRetentionScheduleArgs
 *                             {
 *                                 DaysOfTheWeek = new[]
 *                                 {
 *                                     AzureNative.Workloads.DayOfWeek.Sunday,
 *                                 },
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 104,
 *                                     DurationType = "Weeks",
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2022-11-29T19:30:00.000Z",
 *                                 },
 *                             },
 *                             YearlySchedule = new AzureNative.Workloads.Inputs.YearlyRetentionScheduleArgs
 *                             {
 *                                 MonthsOfYear = new[]
 *                                 {
 *                                     AzureNative.Workloads.MonthOfYear.January,
 *                                 },
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 10,
 *                                     DurationType = "Years",
 *                                 },
 *                                 RetentionScheduleFormatType = "Weekly",
 *                                 RetentionScheduleWeekly = new AzureNative.Workloads.Inputs.WeeklyRetentionFormatArgs
 *                                 {
 *                                     DaysOfTheWeek = new[]
 *                                     {
 *                                         AzureNative.Workloads.DayOfWeek.Sunday,
 *                                     },
 *                                     WeeksOfTheMonth = new[]
 *                                     {
 *                                         AzureNative.Workloads.WeekOfMonth.First,
 *                                     },
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2022-11-29T19:30:00.000Z",
 *                                 },
 *                             },
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                         {
 *                             SchedulePolicyType = "SimpleSchedulePolicy",
 *                             ScheduleRunDays = new[]
 *                             {
 *                                 AzureNative.Workloads.DayOfWeek.Sunday,
 *                             },
 *                             ScheduleRunFrequency = "Weekly",
 *                             ScheduleRunTimes = new[]
 *                             {
 *                                 "2022-11-29T19:30:00.000Z",
 *                             },
 *                         },
 *                         TieringPolicy =
 *                         {
 *                             { "ArchivedRP", new AzureNative.Workloads.Inputs.TieringPolicyArgs
 *                             {
 *                                 Duration = 45,
 *                                 DurationType = "Days",
 *                                 TieringMode = "TierAfter",
 *                             } },
 *                         },
 *                     },
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = "Differential",
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.SimpleRetentionPolicyArgs
 *                         {
 *                             RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 30,
 *                                 DurationType = "Days",
 *                             },
 *                             RetentionPolicyType = "SimpleRetentionPolicy",
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                         {
 *                             SchedulePolicyType = "SimpleSchedulePolicy",
 *                             ScheduleRunDays = new[]
 *                             {
 *                                 AzureNative.Workloads.DayOfWeek.Monday,
 *                             },
 *                             ScheduleRunFrequency = "Weekly",
 *                             ScheduleRunTimes = new[]
 *                             {
 *                                 "2022-09-29T02:00:00Z",
 *                             },
 *                             ScheduleWeeklyFrequency = 0,
 *                         },
 *                     },
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = "Log",
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.SimpleRetentionPolicyArgs
 *                         {
 *                             RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 20,
 *                                 DurationType = "Days",
 *                             },
 *                             RetentionPolicyType = "SimpleRetentionPolicy",
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.LogSchedulePolicyArgs
 *                         {
 *                             ScheduleFrequencyInMins = 120,
 *                             SchedulePolicyType = "LogSchedulePolicy",
 *                         },
 *                     },
 *                 },
 *                 WorkLoadType = "SQLDataBase",
 *             },
 *             BackupType = "SQL",
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.NewRecoveryServicesVaultArgs
 *             {
 *                 Name = "test-vault",
 *                 ResourceGroup = "test-rg",
 *                 VaultType = "New",
 *             },
 *         },
 *         BackupName = "dbBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * 			BackupData: workloads.SqlBackupData{
 * 				BackupPolicy: workloads.DBBackupPolicyProperties{
 * 					BackupManagementType: "AzureWorkload",
 * 					Name:                 "defaultSqlPolicy",
 * 					ProtectedItemsCount:  0,
 * 					Settings: workloads.Settings{
 * 						IsCompression:    true,
 * 						Issqlcompression: true,
 * 						TimeZone:         "UTC",
 * 					},
 * 					SubProtectionPolicy: []workloads.SubProtectionPolicy{
 * 						{
 * 							PolicyType: "Full",
 * 							RetentionPolicy: {
 * 								MonthlySchedule: {
 * 									RetentionDuration: {
 * 										Count:        60,
 * 										DurationType: "Months",
 * 									},
 * 									RetentionScheduleFormatType: "Weekly",
 * 									RetentionScheduleWeekly: {
 * 										DaysOfTheWeek: []workloads.DayOfWeek{
 * 											workloads.DayOfWeekSunday,
 * 										},
 * 										WeeksOfTheMonth: []workloads.WeekOfMonth{
 * 											workloads.WeekOfMonthFirst,
 * 										},
 * 									},
 * 									RetentionTimes: []string{
 * 										"2022-11-29T19:30:00.000Z",
 * 									},
 * 								},
 * 								RetentionPolicyType: "LongTermRetentionPolicy",
 * 								WeeklySchedule: {
 * 									DaysOfTheWeek: []workloads.DayOfWeek{
 * 										workloads.DayOfWeekSunday,
 * 									},
 * 									RetentionDuration: {
 * 										Count:        104,
 * 										DurationType: "Weeks",
 * 									},
 * 									RetentionTimes: []string{
 * 										"2022-11-29T19:30:00.000Z",
 * 									},
 * 								},
 * 								YearlySchedule: {
 * 									MonthsOfYear: []workloads.MonthOfYear{
 * 										workloads.MonthOfYearJanuary,
 * 									},
 * 									RetentionDuration: {
 * 										Count:        10,
 * 										DurationType: "Years",
 * 									},
 * 									RetentionScheduleFormatType: "Weekly",
 * 									RetentionScheduleWeekly: {
 * 										DaysOfTheWeek: []workloads.DayOfWeek{
 * 											workloads.DayOfWeekSunday,
 * 										},
 * 										WeeksOfTheMonth: []workloads.WeekOfMonth{
 * 											workloads.WeekOfMonthFirst,
 * 										},
 * 									},
 * 									RetentionTimes: []string{
 * 										"2022-11-29T19:30:00.000Z",
 * 									},
 * 								},
 * 							},
 * 							SchedulePolicy: {
 * 								SchedulePolicyType: "SimpleSchedulePolicy",
 * 								ScheduleRunDays: []workloads.DayOfWeek{
 * 									workloads.DayOfWeekSunday,
 * 								},
 * 								ScheduleRunFrequency: "Weekly",
 * 								ScheduleRunTimes: []string{
 * 									"2022-11-29T19:30:00.000Z",
 * 								},
 * 							},
 * 							TieringPolicy: {
 * 								ArchivedRP: {
 * 									Duration:     45,
 * 									DurationType: "Days",
 * 									TieringMode:  "TierAfter",
 * 								},
 * 							},
 * 						},
 * 						{
 * 							PolicyType: "Differential",
 * 							RetentionPolicy: {
 * 								RetentionDuration: {
 * 									Count:        30,
 * 									DurationType: "Days",
 * 								},
 * 								RetentionPolicyType: "SimpleRetentionPolicy",
 * 							},
 * 							SchedulePolicy: {
 * 								SchedulePolicyType: "SimpleSchedulePolicy",
 * 								ScheduleRunDays: []workloads.DayOfWeek{
 * 									workloads.DayOfWeekMonday,
 * 								},
 * 								ScheduleRunFrequency: "Weekly",
 * 								ScheduleRunTimes: []string{
 * 									"2022-09-29T02:00:00Z",
 * 								},
 * 								ScheduleWeeklyFrequency: 0,
 * 							},
 * 						},
 * 						{
 * 							PolicyType: "Log",
 * 							RetentionPolicy: {
 * 								RetentionDuration: {
 * 									Count:        20,
 * 									DurationType: "Days",
 * 								},
 * 								RetentionPolicyType: "SimpleRetentionPolicy",
 * 							},
 * 							SchedulePolicy: {
 * 								ScheduleFrequencyInMins: 120,
 * 								SchedulePolicyType:      "LogSchedulePolicy",
 * 							},
 * 						},
 * 					},
 * 					WorkLoadType: "SQLDataBase",
 * 				},
 * 				BackupType: "SQL",
 * 				RecoveryServicesVault: workloads.NewRecoveryServicesVault{
 * 					Name:          "test-vault",
 * 					ResourceGroup: "test-rg",
 * 					VaultType:     "New",
 * 				},
 * 			},
 * 			BackupName:        pulumi.String("dbBackup"),
 * 			ConnectorName:     pulumi.String("C1"),
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(Map.ofEntries(
 *                 Map.entry("backupPolicy", Map.ofEntries(
 *                     Map.entry("backupManagementType", "AzureWorkload"),
 *                     Map.entry("name", "defaultSqlPolicy"),
 *                     Map.entry("protectedItemsCount", 0),
 *                     Map.entry("settings", Map.ofEntries(
 *                         Map.entry("isCompression", true),
 *                         Map.entry("issqlcompression", true),
 *                         Map.entry("timeZone", "UTC")
 *                     )),
 *                     Map.entry("subProtectionPolicy",
 *                         Map.ofEntries(
 *                             Map.entry("policyType", "Full"),
 *                             Map.entry("retentionPolicy", Map.ofEntries(
 *                                 Map.entry("monthlySchedule", Map.ofEntries(
 *                                     Map.entry("retentionDuration", Map.ofEntries(
 *                                         Map.entry("count", 60),
 *                                         Map.entry("durationType", "Months")
 *                                     )),
 *                                     Map.entry("retentionScheduleFormatType", "Weekly"),
 *                                     Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                                         Map.entry("daysOfTheWeek", "Sunday"),
 *                                         Map.entry("weeksOfTheMonth", "First")
 *                                     )),
 *                                     Map.entry("retentionTimes", "2022-11-29T19:30:00.000Z")
 *                                 )),
 *                                 Map.entry("retentionPolicyType", "LongTermRetentionPolicy"),
 *                                 Map.entry("weeklySchedule", Map.ofEntries(
 *                                     Map.entry("daysOfTheWeek", "Sunday"),
 *                                     Map.entry("retentionDuration", Map.ofEntries(
 *                                         Map.entry("count", 104),
 *                                         Map.entry("durationType", "Weeks")
 *                                     )),
 *                                     Map.entry("retentionTimes", "2022-11-29T19:30:00.000Z")
 *                                 )),
 *                                 Map.entry("yearlySchedule", Map.ofEntries(
 *                                     Map.entry("monthsOfYear", "January"),
 *                                     Map.entry("retentionDuration", Map.ofEntries(
 *                                         Map.entry("count", 10),
 *                                         Map.entry("durationType", "Years")
 *                                     )),
 *                                     Map.entry("retentionScheduleFormatType", "Weekly"),
 *                                     Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                                         Map.entry("daysOfTheWeek", "Sunday"),
 *                                         Map.entry("weeksOfTheMonth", "First")
 *                                     )),
 *                                     Map.entry("retentionTimes", "2022-11-29T19:30:00.000Z")
 *                                 ))
 *                             )),
 *                             Map.entry("schedulePolicy", Map.ofEntries(
 *                                 Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                                 Map.entry("scheduleRunDays", "Sunday"),
 *                                 Map.entry("scheduleRunFrequency", "Weekly"),
 *                                 Map.entry("scheduleRunTimes", "2022-11-29T19:30:00.000Z")
 *                             )),
 *                             Map.entry("tieringPolicy", Map.of("ArchivedRP", Map.ofEntries(
 *                                 Map.entry("duration", 45),
 *                                 Map.entry("durationType", "Days"),
 *                                 Map.entry("tieringMode", "TierAfter")
 *                             )))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("policyType", "Differential"),
 *                             Map.entry("retentionPolicy", Map.ofEntries(
 *                                 Map.entry("retentionDuration", Map.ofEntries(
 *                                     Map.entry("count", 30),
 *                                     Map.entry("durationType", "Days")
 *                                 )),
 *                                 Map.entry("retentionPolicyType", "SimpleRetentionPolicy")
 *                             )),
 *                             Map.entry("schedulePolicy", Map.ofEntries(
 *                                 Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                                 Map.entry("scheduleRunDays", "Monday"),
 *                                 Map.entry("scheduleRunFrequency", "Weekly"),
 *                                 Map.entry("scheduleRunTimes", "2022-09-29T02:00:00Z"),
 *                                 Map.entry("scheduleWeeklyFrequency", 0)
 *                             ))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("policyType", "Log"),
 *                             Map.entry("retentionPolicy", Map.ofEntries(
 *                                 Map.entry("retentionDuration", Map.ofEntries(
 *                                     Map.entry("count", 20),
 *                                     Map.entry("durationType", "Days")
 *                                 )),
 *                                 Map.entry("retentionPolicyType", "SimpleRetentionPolicy")
 *                             )),
 *                             Map.entry("schedulePolicy", Map.ofEntries(
 *                                 Map.entry("scheduleFrequencyInMins", 120),
 *                                 Map.entry("schedulePolicyType", "LogSchedulePolicy")
 *                             ))
 *                         )),
 *                     Map.entry("workLoadType", "SQLDataBase")
 *                 )),
 *                 Map.entry("backupType", "SQL"),
 *                 Map.entry("recoveryServicesVault", Map.ofEntries(
 *                     Map.entry("name", "test-vault"),
 *                     Map.entry("resourceGroup", "test-rg"),
 *                     Map.entry("vaultType", "New")
 *                 ))
 *             ))
 *             .backupName("dbBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM backup connection with a new backup policy with tieringPolicy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.VMBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.VMBackupPolicyPropertiesArgs
 *             {
 *                 BackupManagementType = "AzureIaasVM",
 *                 InstantRPDetails = new AzureNative.Workloads.Inputs.InstantRPAdditionalDetailsArgs
 *                 {
 *                     AzureBackupRGNamePrefix = "dasas",
 *                     AzureBackupRGNameSuffix = "a",
 *                 },
 *                 InstantRpRetentionRangeInDays = 2,
 *                 Name = "defaultVmPolicy",
 *                 PolicyType = "V1",
 *                 ProtectedItemsCount = 0,
 *                 RetentionPolicy = new AzureNative.Workloads.Inputs.LongTermRetentionPolicyArgs
 *                 {
 *                     DailySchedule = new AzureNative.Workloads.Inputs.DailyRetentionScheduleArgs
 *                     {
 *                         RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 30,
 *                             DurationType = "Days",
 *                         },
 *                         RetentionTimes = new[]
 *                         {
 *                             "2022-11-29T19:30:00.000Z",
 *                         },
 *                     },
 *                     MonthlySchedule = new AzureNative.Workloads.Inputs.MonthlyRetentionScheduleArgs
 *                     {
 *                         RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 60,
 *                             DurationType = "Months",
 *                         },
 *                         RetentionScheduleFormatType = "Weekly",
 *                         RetentionScheduleWeekly = new AzureNative.Workloads.Inputs.WeeklyRetentionFormatArgs
 *                         {
 *                             DaysOfTheWeek = new[]
 *                             {
 *                                 AzureNative.Workloads.DayOfWeek.Sunday,
 *                             },
 *                             WeeksOfTheMonth = new[]
 *                             {
 *                                 AzureNative.Workloads.WeekOfMonth.First,
 *                             },
 *                         },
 *                         RetentionTimes = new[]
 *                         {
 *                             "2022-11-29T19:30:00.000Z",
 *                         },
 *                     },
 *                     RetentionPolicyType = "LongTermRetentionPolicy",
 *                     WeeklySchedule = new AzureNative.Workloads.Inputs.WeeklyRetentionScheduleArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.Workloads.DayOfWeek.Sunday,
 *                         },
 *                         RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 12,
 *                             DurationType = "Weeks",
 *                         },
 *                         RetentionTimes = new[]
 *                         {
 *                             "2022-11-29T19:30:00.000Z",
 *                         },
 *                     },
 *                     YearlySchedule = new AzureNative.Workloads.Inputs.YearlyRetentionScheduleArgs
 *                     {
 *                         MonthsOfYear = new[]
 *                         {
 *                             AzureNative.Workloads.MonthOfYear.January,
 *                         },
 *                         RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 10,
 *                             DurationType = "Years",
 *                         },
 *                         RetentionScheduleFormatType = "Weekly",
 *                         RetentionScheduleWeekly = new AzureNative.Workloads.Inputs.WeeklyRetentionFormatArgs
 *                         {
 *                             DaysOfTheWeek = new[]
 *                             {
 *                                 AzureNative.Workloads.DayOfWeek.Sunday,
 *                             },
 *                             WeeksOfTheMonth = new[]
 *                             {
 *                                 AzureNative.Workloads.WeekOfMonth.First,
 *                             },
 *                         },
 *                         RetentionTimes = new[]
 *                         {
 *                             "2022-11-29T19:30:00.000Z",
 *                         },
 *                     },
 *                 },
 *                 SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                 {
 *                     SchedulePolicyType = "SimpleSchedulePolicy",
 *                     ScheduleRunFrequency = "Daily",
 *                     ScheduleRunTimes = new[]
 *                     {
 *                         "2022-11-29T19:30:00.000Z",
 *                     },
 *                 },
 *                 TieringPolicy =
 *                 {
 *                     { "ArchivedRP", new AzureNative.Workloads.Inputs.TieringPolicyArgs
 *                     {
 *                         Duration = 3,
 *                         DurationType = "Months",
 *                         TieringMode = "TierAfter",
 *                     } },
 *                 },
 *                 TimeZone = "UTC",
 *             },
 *             BackupType = "VM",
 *             DiskExclusionProperties = new AzureNative.Workloads.Inputs.DiskExclusionPropertiesArgs
 *             {
 *                 DiskLunList = new() { },
 *                 IsInclusionList = true,
 *             },
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.NewRecoveryServicesVaultArgs
 *             {
 *                 Name = "test-vault",
 *                 ResourceGroup = "test-rg",
 *                 VaultType = "New",
 *             },
 *         },
 *         BackupName = "vmBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * BackupData: workloads.VMBackupData{
 * BackupPolicy: workloads.VMBackupPolicyProperties{
 * BackupManagementType: "AzureIaasVM",
 * InstantRPDetails: workloads.InstantRPAdditionalDetails{
 * AzureBackupRGNamePrefix: "dasas",
 * AzureBackupRGNameSuffix: "a",
 * },
 * InstantRpRetentionRangeInDays: 2,
 * Name: "defaultVmPolicy",
 * PolicyType: "V1",
 * ProtectedItemsCount: 0,
 * RetentionPolicy: workloads.LongTermRetentionPolicy{
 * DailySchedule: workloads.DailyRetentionSchedule{
 * RetentionDuration: workloads.RetentionDuration{
 * Count: 30,
 * DurationType: "Days",
 * },
 * RetentionTimes: []string{
 * "2022-11-29T19:30:00.000Z",
 * },
 * },
 * MonthlySchedule: workloads.MonthlyRetentionSchedule{
 * RetentionDuration: workloads.RetentionDuration{
 * Count: 60,
 * DurationType: "Months",
 * },
 * RetentionScheduleFormatType: "Weekly",
 * RetentionScheduleWeekly: workloads.WeeklyRetentionFormat{
 * DaysOfTheWeek: []workloads.DayOfWeek{
 * workloads.DayOfWeekSunday,
 * },
 * WeeksOfTheMonth: []workloads.WeekOfMonth{
 * workloads.WeekOfMonthFirst,
 * },
 * },
 * RetentionTimes: []string{
 * "2022-11-29T19:30:00.000Z",
 * },
 * },
 * RetentionPolicyType: "LongTermRetentionPolicy",
 * WeeklySchedule: workloads.WeeklyRetentionSchedule{
 * DaysOfTheWeek: []workloads.DayOfWeek{
 * workloads.DayOfWeekSunday,
 * },
 * RetentionDuration: workloads.RetentionDuration{
 * Count: 12,
 * DurationType: "Weeks",
 * },
 * RetentionTimes: []string{
 * "2022-11-29T19:30:00.000Z",
 * },
 * },
 * YearlySchedule: workloads.YearlyRetentionSchedule{
 * MonthsOfYear: []workloads.MonthOfYear{
 * workloads.MonthOfYearJanuary,
 * },
 * RetentionDuration: workloads.RetentionDuration{
 * Count: 10,
 * DurationType: "Years",
 * },
 * RetentionScheduleFormatType: "Weekly",
 * RetentionScheduleWeekly: workloads.WeeklyRetentionFormat{
 * DaysOfTheWeek: []workloads.DayOfWeek{
 * workloads.DayOfWeekSunday,
 * },
 * WeeksOfTheMonth: []workloads.WeekOfMonth{
 * workloads.WeekOfMonthFirst,
 * },
 * },
 * RetentionTimes: []string{
 * "2022-11-29T19:30:00.000Z",
 * },
 * },
 * },
 * SchedulePolicy: workloads.SimpleSchedulePolicy{
 * SchedulePolicyType: "SimpleSchedulePolicy",
 * ScheduleRunFrequency: "Daily",
 * ScheduleRunTimes: []string{
 * "2022-11-29T19:30:00.000Z",
 * },
 * },
 * TieringPolicy: interface{}{
 * ArchivedRP: workloads.TieringPolicy{
 * Duration: 3,
 * DurationType: "Months",
 * TieringMode: "TierAfter",
 * },
 * },
 * TimeZone: "UTC",
 * },
 * BackupType: "VM",
 * DiskExclusionProperties: workloads.DiskExclusionProperties{
 * DiskLunList: []interface{}{
 * },
 * IsInclusionList: true,
 * },
 * RecoveryServicesVault: workloads.NewRecoveryServicesVault{
 * Name: "test-vault",
 * ResourceGroup: "test-rg",
 * VaultType: "New",
 * },
 * },
 * BackupName: pulumi.String("vmBackup"),
 * ConnectorName: pulumi.String("C1"),
 * Location: pulumi.String("westcentralus"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(Map.ofEntries(
 *                 Map.entry("backupPolicy", Map.ofEntries(
 *                     Map.entry("backupManagementType", "AzureIaasVM"),
 *                     Map.entry("instantRPDetails", Map.ofEntries(
 *                         Map.entry("azureBackupRGNamePrefix", "dasas"),
 *                         Map.entry("azureBackupRGNameSuffix", "a")
 *                     )),
 *                     Map.entry("instantRpRetentionRangeInDays", 2),
 *                     Map.entry("name", "defaultVmPolicy"),
 *                     Map.entry("policyType", "V1"),
 *                     Map.entry("protectedItemsCount", 0),
 *                     Map.entry("retentionPolicy", Map.ofEntries(
 *                         Map.entry("dailySchedule", Map.ofEntries(
 *                             Map.entry("retentionDuration", Map.ofEntries(
 *                                 Map.entry("count", 30),
 *                                 Map.entry("durationType", "Days")
 *                             )),
 *                             Map.entry("retentionTimes", "2022-11-29T19:30:00.000Z")
 *                         )),
 *                         Map.entry("monthlySchedule", Map.ofEntries(
 *                             Map.entry("retentionDuration", Map.ofEntries(
 *                                 Map.entry("count", 60),
 *                                 Map.entry("durationType", "Months")
 *                             )),
 *                             Map.entry("retentionScheduleFormatType", "Weekly"),
 *                             Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                                 Map.entry("daysOfTheWeek", "Sunday"),
 *                                 Map.entry("weeksOfTheMonth", "First")
 *                             )),
 *                             Map.entry("retentionTimes", "2022-11-29T19:30:00.000Z")
 *                         )),
 *                         Map.entry("retentionPolicyType", "LongTermRetentionPolicy"),
 *                         Map.entry("weeklySchedule", Map.ofEntries(
 *                             Map.entry("daysOfTheWeek", "Sunday"),
 *                             Map.entry("retentionDuration", Map.ofEntries(
 *                                 Map.entry("count", 12),
 *                                 Map.entry("durationType", "Weeks")
 *                             )),
 *                             Map.entry("retentionTimes", "2022-11-29T19:30:00.000Z")
 *                         )),
 *                         Map.entry("yearlySchedule", Map.ofEntries(
 *                             Map.entry("monthsOfYear", "January"),
 *                             Map.entry("retentionDuration", Map.ofEntries(
 *                                 Map.entry("count", 10),
 *                                 Map.entry("durationType", "Years")
 *                             )),
 *                             Map.entry("retentionScheduleFormatType", "Weekly"),
 *                             Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                                 Map.entry("daysOfTheWeek", "Sunday"),
 *                                 Map.entry("weeksOfTheMonth", "First")
 *                             )),
 *                             Map.entry("retentionTimes", "2022-11-29T19:30:00.000Z")
 *                         ))
 *                     )),
 *                     Map.entry("schedulePolicy", Map.ofEntries(
 *                         Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                         Map.entry("scheduleRunFrequency", "Daily"),
 *                         Map.entry("scheduleRunTimes", "2022-11-29T19:30:00.000Z")
 *                     )),
 *                     Map.entry("tieringPolicy", Map.of("ArchivedRP", Map.ofEntries(
 *                         Map.entry("duration", 3),
 *                         Map.entry("durationType", "Months"),
 *                         Map.entry("tieringMode", "TierAfter")
 *                     ))),
 *                     Map.entry("timeZone", "UTC")
 *                 )),
 *                 Map.entry("backupType", "VM"),
 *                 Map.entry("diskExclusionProperties", Map.ofEntries(
 *                     Map.entry("diskLunList", ),
 *                     Map.entry("isInclusionList", true)
 *                 )),
 *                 Map.entry("recoveryServicesVault", Map.ofEntries(
 *                     Map.entry("name", "test-vault"),
 *                     Map.entry("resourceGroup", "test-rg"),
 *                     Map.entry("vaultType", "New")
 *                 ))
 *             ))
 *             .backupName("vmBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a db backup connection with a new backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.SqlBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.DBBackupPolicyPropertiesArgs
 *             {
 *                 BackupManagementType = "AzureWorkload",
 *                 Name = "defaultDbPolicy",
 *                 ProtectedItemsCount = 0,
 *                 Settings = new AzureNative.Workloads.Inputs.SettingsArgs
 *                 {
 *                     IsCompression = false,
 *                     Issqlcompression = false,
 *                     TimeZone = "UTC",
 *                 },
 *                 SubProtectionPolicy = new[]
 *                 {
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = "Full",
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.LongTermRetentionPolicyArgs
 *                         {
 *                             DailySchedule = new AzureNative.Workloads.Inputs.DailyRetentionScheduleArgs
 *                             {
 *                                 RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                                 {
 *                                     Count = 30,
 *                                     DurationType = "Days",
 *                                 },
 *                                 RetentionTimes = new[]
 *                                 {
 *                                     "2018-01-10T18:30:00Z",
 *                                 },
 *                             },
 *                             RetentionPolicyType = "LongTermRetentionPolicy",
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                         {
 *                             SchedulePolicyType = "SimpleSchedulePolicy",
 *                             ScheduleRunFrequency = "Daily",
 *                             ScheduleRunTimes = new[]
 *                             {
 *                                 "2018-01-10T18:30:00Z",
 *                             },
 *                             ScheduleWeeklyFrequency = 0,
 *                         },
 *                     },
 *                     new AzureNative.Workloads.Inputs.SubProtectionPolicyArgs
 *                     {
 *                         PolicyType = "Log",
 *                         RetentionPolicy = new AzureNative.Workloads.Inputs.SimpleRetentionPolicyArgs
 *                         {
 *                             RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 30,
 *                                 DurationType = "Days",
 *                             },
 *                             RetentionPolicyType = "SimpleRetentionPolicy",
 *                         },
 *                         SchedulePolicy = new AzureNative.Workloads.Inputs.LogSchedulePolicyArgs
 *                         {
 *                             ScheduleFrequencyInMins = 60,
 *                             SchedulePolicyType = "LogSchedulePolicy",
 *                         },
 *                     },
 *                 },
 *                 WorkLoadType = "SQLDataBase",
 *             },
 *             BackupType = "SQL",
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.ExistingRecoveryServicesVaultArgs
 *             {
 *                 Id = "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault",
 *                 VaultType = "Existing",
 *             },
 *         },
 *         BackupName = "dbBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * 			BackupData: workloads.SqlBackupData{
 * 				BackupPolicy: workloads.DBBackupPolicyProperties{
 * 					BackupManagementType: "AzureWorkload",
 * 					Name:                 "defaultDbPolicy",
 * 					ProtectedItemsCount:  0,
 * 					Settings: workloads.Settings{
 * 						IsCompression:    false,
 * 						Issqlcompression: false,
 * 						TimeZone:         "UTC",
 * 					},
 * 					SubProtectionPolicy: []workloads.SubProtectionPolicy{
 * 						{
 * 							PolicyType: "Full",
 * 							RetentionPolicy: {
 * 								DailySchedule: {
 * 									RetentionDuration: {
 * 										Count:        30,
 * 										DurationType: "Days",
 * 									},
 * 									RetentionTimes: []string{
 * 										"2018-01-10T18:30:00Z",
 * 									},
 * 								},
 * 								RetentionPolicyType: "LongTermRetentionPolicy",
 * 							},
 * 							SchedulePolicy: {
 * 								SchedulePolicyType:   "SimpleSchedulePolicy",
 * 								ScheduleRunFrequency: "Daily",
 * 								ScheduleRunTimes: []string{
 * 									"2018-01-10T18:30:00Z",
 * 								},
 * 								ScheduleWeeklyFrequency: 0,
 * 							},
 * 						},
 * 						{
 * 							PolicyType: "Log",
 * 							RetentionPolicy: {
 * 								RetentionDuration: {
 * 									Count:        30,
 * 									DurationType: "Days",
 * 								},
 * 								RetentionPolicyType: "SimpleRetentionPolicy",
 * 							},
 * 							SchedulePolicy: {
 * 								ScheduleFrequencyInMins: 60,
 * 								SchedulePolicyType:      "LogSchedulePolicy",
 * 							},
 * 						},
 * 					},
 * 					WorkLoadType: "SQLDataBase",
 * 				},
 * 				BackupType: "SQL",
 * 				RecoveryServicesVault: workloads.ExistingRecoveryServicesVault{
 * 					Id:        "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault",
 * 					VaultType: "Existing",
 * 				},
 * 			},
 * 			BackupName:        pulumi.String("dbBackup"),
 * 			ConnectorName:     pulumi.String("C1"),
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(Map.ofEntries(
 *                 Map.entry("backupPolicy", Map.ofEntries(
 *                     Map.entry("backupManagementType", "AzureWorkload"),
 *                     Map.entry("name", "defaultDbPolicy"),
 *                     Map.entry("protectedItemsCount", 0),
 *                     Map.entry("settings", Map.ofEntries(
 *                         Map.entry("isCompression", false),
 *                         Map.entry("issqlcompression", false),
 *                         Map.entry("timeZone", "UTC")
 *                     )),
 *                     Map.entry("subProtectionPolicy",
 *                         Map.ofEntries(
 *                             Map.entry("policyType", "Full"),
 *                             Map.entry("retentionPolicy", Map.ofEntries(
 *                                 Map.entry("dailySchedule", Map.ofEntries(
 *                                     Map.entry("retentionDuration", Map.ofEntries(
 *                                         Map.entry("count", 30),
 *                                         Map.entry("durationType", "Days")
 *                                     )),
 *                                     Map.entry("retentionTimes", "2018-01-10T18:30:00Z")
 *                                 )),
 *                                 Map.entry("retentionPolicyType", "LongTermRetentionPolicy")
 *                             )),
 *                             Map.entry("schedulePolicy", Map.ofEntries(
 *                                 Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                                 Map.entry("scheduleRunFrequency", "Daily"),
 *                                 Map.entry("scheduleRunTimes", "2018-01-10T18:30:00Z"),
 *                                 Map.entry("scheduleWeeklyFrequency", 0)
 *                             ))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("policyType", "Log"),
 *                             Map.entry("retentionPolicy", Map.ofEntries(
 *                                 Map.entry("retentionDuration", Map.ofEntries(
 *                                     Map.entry("count", 30),
 *                                     Map.entry("durationType", "Days")
 *                                 )),
 *                                 Map.entry("retentionPolicyType", "SimpleRetentionPolicy")
 *                             )),
 *                             Map.entry("schedulePolicy", Map.ofEntries(
 *                                 Map.entry("scheduleFrequencyInMins", 60),
 *                                 Map.entry("schedulePolicyType", "LogSchedulePolicy")
 *                             ))
 *                         )),
 *                     Map.entry("workLoadType", "SQLDataBase")
 *                 )),
 *                 Map.entry("backupType", "SQL"),
 *                 Map.entry("recoveryServicesVault", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault"),
 *                     Map.entry("vaultType", "Existing")
 *                 ))
 *             ))
 *             .backupName("dbBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a db backup connection with an existing backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.SqlBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.DBBackupPolicyPropertiesArgs
 *             {
 *                 Name = "defaultDbPolicy",
 *             },
 *             BackupType = "SQL",
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.ExistingRecoveryServicesVaultArgs
 *             {
 *                 Id = "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault",
 *                 VaultType = "Existing",
 *             },
 *         },
 *         BackupName = "dbBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * 			BackupData: workloads.SqlBackupData{
 * 				BackupPolicy: workloads.DBBackupPolicyProperties{
 * 					Name: "defaultDbPolicy",
 * 				},
 * 				BackupType: "SQL",
 * 				RecoveryServicesVault: workloads.ExistingRecoveryServicesVault{
 * 					Id:        "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault",
 * 					VaultType: "Existing",
 * 				},
 * 			},
 * 			BackupName:        pulumi.String("dbBackup"),
 * 			ConnectorName:     pulumi.String("C1"),
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(Map.ofEntries(
 *                 Map.entry("backupPolicy", Map.of("name", "defaultDbPolicy")),
 *                 Map.entry("backupType", "SQL"),
 *                 Map.entry("recoveryServicesVault", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault"),
 *                     Map.entry("vaultType", "Existing")
 *                 ))
 *             ))
 *             .backupName("dbBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm backup connection with a new backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.VMBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.VMBackupPolicyPropertiesArgs
 *             {
 *                 BackupManagementType = "AzureIaasVM",
 *                 InstantRPDetails = null,
 *                 InstantRpRetentionRangeInDays = 2,
 *                 Name = "defaultVmPolicy",
 *                 ProtectedItemsCount = 0,
 *                 RetentionPolicy = new AzureNative.Workloads.Inputs.LongTermRetentionPolicyArgs
 *                 {
 *                     DailySchedule = new AzureNative.Workloads.Inputs.DailyRetentionScheduleArgs
 *                     {
 *                         RetentionDuration = new AzureNative.Workloads.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 30,
 *                             DurationType = "Days",
 *                         },
 *                         RetentionTimes = new[]
 *                         {
 *                             "2018-01-10T18:30:00Z",
 *                         },
 *                     },
 *                     RetentionPolicyType = "LongTermRetentionPolicy",
 *                 },
 *                 SchedulePolicy = new AzureNative.Workloads.Inputs.SimpleSchedulePolicyArgs
 *                 {
 *                     SchedulePolicyType = "SimpleSchedulePolicy",
 *                     ScheduleRunFrequency = "Daily",
 *                     ScheduleRunTimes = new[]
 *                     {
 *                         "2018-01-10T18:30:00Z",
 *                     },
 *                     ScheduleWeeklyFrequency = 0,
 *                 },
 *             },
 *             BackupType = "VM",
 *             DiskExclusionProperties = new AzureNative.Workloads.Inputs.DiskExclusionPropertiesArgs
 *             {
 *                 DiskLunList = new() { },
 *                 IsInclusionList = true,
 *             },
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.NewRecoveryServicesVaultArgs
 *             {
 *                 Name = "test-vault",
 *                 ResourceGroup = "test-rg",
 *                 VaultType = "New",
 *             },
 *         },
 *         BackupName = "vmBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * 			BackupData: workloads.VMBackupData{
 * 				BackupPolicy: workloads.VMBackupPolicyProperties{
 * 					BackupManagementType:          "AzureIaasVM",
 * 					InstantRPDetails:              nil,
 * 					InstantRpRetentionRangeInDays: 2,
 * 					Name:                          "defaultVmPolicy",
 * 					ProtectedItemsCount:           0,
 * 					RetentionPolicy: workloads.LongTermRetentionPolicy{
 * 						DailySchedule: workloads.DailyRetentionSchedule{
 * 							RetentionDuration: workloads.RetentionDuration{
 * 								Count:        30,
 * 								DurationType: "Days",
 * 							},
 * 							RetentionTimes: []string{
 * 								"2018-01-10T18:30:00Z",
 * 							},
 * 						},
 * 						RetentionPolicyType: "LongTermRetentionPolicy",
 * 					},
 * 					SchedulePolicy: workloads.SimpleSchedulePolicy{
 * 						SchedulePolicyType:   "SimpleSchedulePolicy",
 * 						ScheduleRunFrequency: "Daily",
 * 						ScheduleRunTimes: []string{
 * 							"2018-01-10T18:30:00Z",
 * 						},
 * 						ScheduleWeeklyFrequency: 0,
 * 					},
 * 				},
 * 				BackupType: "VM",
 * 				DiskExclusionProperties: workloads.DiskExclusionProperties{
 * 					DiskLunList:     []interface{}{},
 * 					IsInclusionList: true,
 * 				},
 * 				RecoveryServicesVault: workloads.NewRecoveryServicesVault{
 * 					Name:          "test-vault",
 * 					ResourceGroup: "test-rg",
 * 					VaultType:     "New",
 * 				},
 * 			},
 * 			BackupName:        pulumi.String("vmBackup"),
 * 			ConnectorName:     pulumi.String("C1"),
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(Map.ofEntries(
 *                 Map.entry("backupPolicy", Map.ofEntries(
 *                     Map.entry("backupManagementType", "AzureIaasVM"),
 *                     Map.entry("instantRPDetails", ),
 *                     Map.entry("instantRpRetentionRangeInDays", 2),
 *                     Map.entry("name", "defaultVmPolicy"),
 *                     Map.entry("protectedItemsCount", 0),
 *                     Map.entry("retentionPolicy", Map.ofEntries(
 *                         Map.entry("dailySchedule", Map.ofEntries(
 *                             Map.entry("retentionDuration", Map.ofEntries(
 *                                 Map.entry("count", 30),
 *                                 Map.entry("durationType", "Days")
 *                             )),
 *                             Map.entry("retentionTimes", "2018-01-10T18:30:00Z")
 *                         )),
 *                         Map.entry("retentionPolicyType", "LongTermRetentionPolicy")
 *                     )),
 *                     Map.entry("schedulePolicy", Map.ofEntries(
 *                         Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                         Map.entry("scheduleRunFrequency", "Daily"),
 *                         Map.entry("scheduleRunTimes", "2018-01-10T18:30:00Z"),
 *                         Map.entry("scheduleWeeklyFrequency", 0)
 *                     ))
 *                 )),
 *                 Map.entry("backupType", "VM"),
 *                 Map.entry("diskExclusionProperties", Map.ofEntries(
 *                     Map.entry("diskLunList", ),
 *                     Map.entry("isInclusionList", true)
 *                 )),
 *                 Map.entry("recoveryServicesVault", Map.ofEntries(
 *                     Map.entry("name", "test-vault"),
 *                     Map.entry("resourceGroup", "test-rg"),
 *                     Map.entry("vaultType", "New")
 *                 ))
 *             ))
 *             .backupName("vmBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm backup connection with an existing backup policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acssBackupConnection = new AzureNative.Workloads.ACSSBackupConnection("acssBackupConnection", new()
 *     {
 *         BackupData = new AzureNative.Workloads.Inputs.VMBackupDataArgs
 *         {
 *             BackupPolicy = new AzureNative.Workloads.Inputs.VMBackupPolicyPropertiesArgs
 *             {
 *                 Name = "defaultVmPolicy",
 *             },
 *             BackupType = "VM",
 *             DiskExclusionProperties = new AzureNative.Workloads.Inputs.DiskExclusionPropertiesArgs
 *             {
 *                 DiskLunList = new() { },
 *                 IsInclusionList = true,
 *             },
 *             RecoveryServicesVault = new AzureNative.Workloads.Inputs.ExistingRecoveryServicesVaultArgs
 *             {
 *                 Id = "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault",
 *                 VaultType = "Existing",
 *             },
 *         },
 *         BackupName = "vmBackup",
 *         ConnectorName = "C1",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewACSSBackupConnection(ctx, "acssBackupConnection", &workloads.ACSSBackupConnectionArgs{
 * 			BackupData: workloads.VMBackupData{
 * 				BackupPolicy: workloads.VMBackupPolicyProperties{
 * 					Name: "defaultVmPolicy",
 * 				},
 * 				BackupType: "VM",
 * 				DiskExclusionProperties: workloads.DiskExclusionProperties{
 * 					DiskLunList:     []interface{}{},
 * 					IsInclusionList: true,
 * 				},
 * 				RecoveryServicesVault: workloads.ExistingRecoveryServicesVault{
 * 					Id:        "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault",
 * 					VaultType: "Existing",
 * 				},
 * 			},
 * 			BackupName:        pulumi.String("vmBackup"),
 * 			ConnectorName:     pulumi.String("C1"),
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnection;
 * import com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acssBackupConnection = new ACSSBackupConnection("acssBackupConnection", ACSSBackupConnectionArgs.builder()
 *             .backupData(Map.ofEntries(
 *                 Map.entry("backupPolicy", Map.of("name", "defaultVmPolicy")),
 *                 Map.entry("backupType", "VM"),
 *                 Map.entry("diskExclusionProperties", Map.ofEntries(
 *                     Map.entry("diskLunList", ),
 *                     Map.entry("isInclusionList", true)
 *                 )),
 *                 Map.entry("recoveryServicesVault", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.RecoveryServices/vaults/test-vault"),
 *                     Map.entry("vaultType", "Existing")
 *                 ))
 *             ))
 *             .backupName("vmBackup")
 *             .connectorName("C1")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:ACSSBackupConnection db1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/connectors/{connectorName}/acssBackups/{backupName}
 * ```
 * @property backupData Information about the recovery services vault and backup policy used for backup.
 * @property backupName The name of the backup connection resource of virtual instance for SAP.
 * @property connectorName The name of the connector resource
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ACSSBackupConnectionArgs(
    public val backupData: Output<Any>? = null,
    public val backupName: Output<String>? = null,
    public val connectorName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs =
        com.pulumi.azurenative.workloads.ACSSBackupConnectionArgs.builder()
            .backupData(backupData?.applyValue({ args0 -> args0 }))
            .backupName(backupName?.applyValue({ args0 -> args0 }))
            .connectorName(connectorName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ACSSBackupConnectionArgs].
 */
@PulumiTagMarker
public class ACSSBackupConnectionArgsBuilder internal constructor() {
    private var backupData: Output<Any>? = null

    private var backupName: Output<String>? = null

    private var connectorName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Information about the recovery services vault and backup policy used for backup.
     */
    @JvmName("ctlbjdmktmjjychu")
    public suspend fun backupData(`value`: Output<Any>) {
        this.backupData = value
    }

    /**
     * @param value The name of the backup connection resource of virtual instance for SAP.
     */
    @JvmName("knkcugltkgeeykam")
    public suspend fun backupName(`value`: Output<String>) {
        this.backupName = value
    }

    /**
     * @param value The name of the connector resource
     */
    @JvmName("xvnlyhllgrkdbdux")
    public suspend fun connectorName(`value`: Output<String>) {
        this.connectorName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hxcdhltervhrgaub")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lmkmhbhstnelulmk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dnopnisrxqaiuyny")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Information about the recovery services vault and backup policy used for backup.
     */
    @JvmName("xkjfhxaurfggppao")
    public suspend fun backupData(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupData = mapped
    }

    /**
     * @param value The name of the backup connection resource of virtual instance for SAP.
     */
    @JvmName("qxppokkqacjkvlqr")
    public suspend fun backupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupName = mapped
    }

    /**
     * @param value The name of the connector resource
     */
    @JvmName("lvivxrvyairkvwya")
    public suspend fun connectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("iuqowlugukbtcnuw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hxcfjmjbsvdujrcb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lxsypwbsawyxuhai")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hslbkeybnvkmltlq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ACSSBackupConnectionArgs = ACSSBackupConnectionArgs(
        backupData = backupData,
        backupName = backupName,
        connectorName = connectorName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
