@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.kotlin.outputs.ApplicationServerVmDetailsResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.LoadBalancerDetailsResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.workloads.kotlin.outputs.ApplicationServerVmDetailsResponse.Companion.toKotlin as applicationServerVmDetailsResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.LoadBalancerDetailsResponse.Companion.toKotlin as loadBalancerDetailsResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse.Companion.toKotlin as sAPVirtualInstanceErrorResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SAPApplicationServerInstance].
 */
@PulumiTagMarker
public class SAPApplicationServerInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SAPApplicationServerInstanceArgs = SAPApplicationServerInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SAPApplicationServerInstanceArgsBuilder.() -> Unit) {
        val builder = SAPApplicationServerInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SAPApplicationServerInstance {
        val builtJavaResource =
            com.pulumi.azurenative.workloads.SAPApplicationServerInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SAPApplicationServerInstance(builtJavaResource)
    }
}

/**
 * Define the SAP Application Server Instance resource.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * Other available API versions: 2021-12-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Create SAP Application Server Instances for HA System with Availability Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapApplicationServerInstance = new AzureNative.Workloads.SAPApplicationServerInstance("sapApplicationServerInstance", new()
 *     {
 *         ApplicationInstanceName = "app01",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPApplicationServerInstance(ctx, "sapApplicationServerInstance", &workloads.SAPApplicationServerInstanceArgs{
 * 			ApplicationInstanceName: pulumi.String("app01"),
 * 			Location:                pulumi.String("westcentralus"),
 * 			ResourceGroupName:       pulumi.String("test-rg"),
 * 			SapVirtualInstanceName:  pulumi.String("X00"),
 * 			Tags:                    nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPApplicationServerInstance;
 * import com.pulumi.azurenative.workloads.SAPApplicationServerInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapApplicationServerInstance = new SAPApplicationServerInstance("sapApplicationServerInstance", SAPApplicationServerInstanceArgs.builder()
 *             .applicationInstanceName("app01")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### SAPApplicationServerInstances_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapApplicationServerInstance = new AzureNative.Workloads.SAPApplicationServerInstance("sapApplicationServerInstance", new()
 *     {
 *         ApplicationInstanceName = "app01",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPApplicationServerInstance(ctx, "sapApplicationServerInstance", &workloads.SAPApplicationServerInstanceArgs{
 * 			ApplicationInstanceName: pulumi.String("app01"),
 * 			Location:                pulumi.String("westcentralus"),
 * 			ResourceGroupName:       pulumi.String("test-rg"),
 * 			SapVirtualInstanceName:  pulumi.String("X00"),
 * 			Tags:                    nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPApplicationServerInstance;
 * import com.pulumi.azurenative.workloads.SAPApplicationServerInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapApplicationServerInstance = new SAPApplicationServerInstance("sapApplicationServerInstance", SAPApplicationServerInstanceArgs.builder()
 *             .applicationInstanceName("app01")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:SAPApplicationServerInstance app01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapVirtualInstances/{sapVirtualInstanceName}/applicationInstances/{applicationInstanceName}
 * ```
 */
public class SAPApplicationServerInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.workloads.SAPApplicationServerInstance,
) : KotlinCustomResource(javaResource, SAPApplicationServerInstanceMapper) {
    /**
     * Defines the Application Instance errors.
     */
    public val errors: Output<SAPVirtualInstanceErrorResponse>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.let({ args0 ->
                sAPVirtualInstanceErrorResponseToKotlin(args0)
            })
        })

    /**
     * Application server instance gateway Port.
     */
    public val gatewayPort: Output<Double>
        get() = javaResource.gatewayPort().applyValue({ args0 -> args0 })

    /**
     * Defines the health of SAP Instances.
     */
    public val health: Output<String>
        get() = javaResource.health().applyValue({ args0 -> args0 })

    /**
     * Application server instance SAP hostname.
     */
    public val hostname: Output<String>
        get() = javaResource.hostname().applyValue({ args0 -> args0 })

    /**
     * Application server instance ICM HTTP Port.
     */
    public val icmHttpPort: Output<Double>
        get() = javaResource.icmHttpPort().applyValue({ args0 -> args0 })

    /**
     * Application server instance ICM HTTPS Port.
     */
    public val icmHttpsPort: Output<Double>
        get() = javaResource.icmHttpsPort().applyValue({ args0 -> args0 })

    /**
     * Application server Instance Number.
     */
    public val instanceNo: Output<String>
        get() = javaResource.instanceNo().applyValue({ args0 -> args0 })

    /**
     *  Application server instance SAP IP Address.
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * Application server instance SAP Kernel Patch level.
     */
    public val kernelPatch: Output<String>
        get() = javaResource.kernelPatch().applyValue({ args0 -> args0 })

    /**
     *  Application server instance SAP Kernel Version.
     */
    public val kernelVersion: Output<String>
        get() = javaResource.kernelVersion().applyValue({ args0 -> args0 })

    /**
     * The Load Balancer details such as LoadBalancer ID attached to Application Server Virtual Machines
     */
    public val loadBalancerDetails: Output<LoadBalancerDetailsResponse>
        get() = javaResource.loadBalancerDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                loadBalancerDetailsResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the provisioning states.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Defines the SAP Instance status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Application server Subnet.
     */
    public val subnet: Output<String>
        get() = javaResource.subnet().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The list of virtual machines.
     */
    public val vmDetails: Output<List<ApplicationServerVmDetailsResponse>>
        get() = javaResource.vmDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    applicationServerVmDetailsResponseToKotlin(args0)
                })
            })
        })
}

public object SAPApplicationServerInstanceMapper : ResourceMapper<SAPApplicationServerInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.workloads.SAPApplicationServerInstance::class == javaResource::class

    override fun map(javaResource: Resource): SAPApplicationServerInstance =
        SAPApplicationServerInstance(
            javaResource as
                com.pulumi.azurenative.workloads.SAPApplicationServerInstance,
        )
}

/**
 * @see [SAPApplicationServerInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SAPApplicationServerInstance].
 */
public suspend fun sapApplicationServerInstance(
    name: String,
    block: suspend SAPApplicationServerInstanceResourceBuilder.() -> Unit,
):
    SAPApplicationServerInstance {
    val builder = SAPApplicationServerInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SAPApplicationServerInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sapApplicationServerInstance(name: String): SAPApplicationServerInstance {
    val builder = SAPApplicationServerInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
