@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.WorkloadsFunctions.getACSSBackupConnectionPlain
import com.pulumi.azurenative.workloads.WorkloadsFunctions.getConnectorPlain
import com.pulumi.azurenative.workloads.WorkloadsFunctions.getMonitorPlain
import com.pulumi.azurenative.workloads.WorkloadsFunctions.getProviderInstancePlain
import com.pulumi.azurenative.workloads.WorkloadsFunctions.getSAPApplicationServerInstancePlain
import com.pulumi.azurenative.workloads.WorkloadsFunctions.getSAPAvailabilityZoneDetailsPlain
import com.pulumi.azurenative.workloads.WorkloadsFunctions.getSAPCentralInstancePlain
import com.pulumi.azurenative.workloads.WorkloadsFunctions.getSAPDatabaseInstancePlain
import com.pulumi.azurenative.workloads.WorkloadsFunctions.getSAPDiskConfigurationsPlain
import com.pulumi.azurenative.workloads.WorkloadsFunctions.getSAPSizingRecommendationsPlain
import com.pulumi.azurenative.workloads.WorkloadsFunctions.getSAPSupportedSkuPlain
import com.pulumi.azurenative.workloads.WorkloadsFunctions.getSAPVirtualInstancePlain
import com.pulumi.azurenative.workloads.WorkloadsFunctions.getSapLandscapeMonitorPlain
import com.pulumi.azurenative.workloads.kotlin.enums.SAPDatabaseScaleMethod
import com.pulumi.azurenative.workloads.kotlin.enums.SAPDatabaseType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPDeploymentType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPEnvironmentType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPHighAvailabilityType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPProductType
import com.pulumi.azurenative.workloads.kotlin.inputs.GetACSSBackupConnectionPlainArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.GetACSSBackupConnectionPlainArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.GetConnectorPlainArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.GetConnectorPlainArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.GetMonitorPlainArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.GetMonitorPlainArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.GetProviderInstancePlainArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.GetProviderInstancePlainArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPApplicationServerInstancePlainArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPApplicationServerInstancePlainArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPAvailabilityZoneDetailsPlainArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPAvailabilityZoneDetailsPlainArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPCentralInstancePlainArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPCentralInstancePlainArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPDatabaseInstancePlainArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPDatabaseInstancePlainArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPDiskConfigurationsPlainArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPDiskConfigurationsPlainArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPSizingRecommendationsPlainArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPSizingRecommendationsPlainArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPSupportedSkuPlainArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPSupportedSkuPlainArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPVirtualInstancePlainArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSAPVirtualInstancePlainArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSapLandscapeMonitorPlainArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.GetSapLandscapeMonitorPlainArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.outputs.GetACSSBackupConnectionResult
import com.pulumi.azurenative.workloads.kotlin.outputs.GetConnectorResult
import com.pulumi.azurenative.workloads.kotlin.outputs.GetMonitorResult
import com.pulumi.azurenative.workloads.kotlin.outputs.GetProviderInstanceResult
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPApplicationServerInstanceResult
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPAvailabilityZoneDetailsResult
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPCentralInstanceResult
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPDatabaseInstanceResult
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPDiskConfigurationsResult
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPSizingRecommendationsResult
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPSupportedSkuResult
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPVirtualInstanceResult
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSapLandscapeMonitorResult
import com.pulumi.core.Either
import kotlinx.coroutines.future.await
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.workloads.kotlin.outputs.GetACSSBackupConnectionResult.Companion.toKotlin as getACSSBackupConnectionResultToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.GetConnectorResult.Companion.toKotlin as getConnectorResultToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.GetMonitorResult.Companion.toKotlin as getMonitorResultToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.GetProviderInstanceResult.Companion.toKotlin as getProviderInstanceResultToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPApplicationServerInstanceResult.Companion.toKotlin as getSAPApplicationServerInstanceResultToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPAvailabilityZoneDetailsResult.Companion.toKotlin as getSAPAvailabilityZoneDetailsResultToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPCentralInstanceResult.Companion.toKotlin as getSAPCentralInstanceResultToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPDatabaseInstanceResult.Companion.toKotlin as getSAPDatabaseInstanceResultToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPDiskConfigurationsResult.Companion.toKotlin as getSAPDiskConfigurationsResultToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPSizingRecommendationsResult.Companion.toKotlin as getSAPSizingRecommendationsResultToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPSupportedSkuResult.Companion.toKotlin as getSAPSupportedSkuResultToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSAPVirtualInstanceResult.Companion.toKotlin as getSAPVirtualInstanceResultToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.GetSapLandscapeMonitorResult.Companion.toKotlin as getSapLandscapeMonitorResultToKotlin

public object WorkloadsFunctions {
    /**
     * Gets the backup connection resource of virtual instance for SAP.
     * Azure REST API version: 2023-10-01-preview.
     * @param argument null
     * @return Define the backup connection resource of virtual instance for SAP..
     */
    public suspend fun getACSSBackupConnection(argument: GetACSSBackupConnectionPlainArgs):
        GetACSSBackupConnectionResult =
        getACSSBackupConnectionResultToKotlin(getACSSBackupConnectionPlain(argument.toJava()).await())

    /**
     * @see [getACSSBackupConnection].
     * @param backupName The name of the backup connection resource of virtual instance for SAP.
     * @param connectorName The name of the connector resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Define the backup connection resource of virtual instance for SAP..
     */
    public suspend fun getACSSBackupConnection(
        backupName: String,
        connectorName: String,
        resourceGroupName: String,
    ): GetACSSBackupConnectionResult {
        val argument = GetACSSBackupConnectionPlainArgs(
            backupName = backupName,
            connectorName = connectorName,
            resourceGroupName = resourceGroupName,
        )
        return getACSSBackupConnectionResultToKotlin(getACSSBackupConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getACSSBackupConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;workloads&#46;kotlin&#46;inputs&#46;GetACSSBackupConnectionPlainArgs].
     * @return Define the backup connection resource of virtual instance for SAP..
     */
    public suspend
    fun getACSSBackupConnection(argument: suspend GetACSSBackupConnectionPlainArgsBuilder.() -> Unit):
        GetACSSBackupConnectionResult {
        val builder = GetACSSBackupConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getACSSBackupConnectionResultToKotlin(getACSSBackupConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a connector resource
     * Azure REST API version: 2023-10-01-preview.
     * @param argument null
     * @return Define the connector resource.
     */
    public suspend fun getConnector(argument: GetConnectorPlainArgs): GetConnectorResult =
        getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())

    /**
     * @see [getConnector].
     * @param connectorName The name of the connector resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Define the connector resource.
     */
    public suspend fun getConnector(connectorName: String, resourceGroupName: String):
        GetConnectorResult {
        val argument = GetConnectorPlainArgs(
            connectorName = connectorName,
            resourceGroupName = resourceGroupName,
        )
        return getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;workloads&#46;kotlin&#46;inputs&#46;GetConnectorPlainArgs].
     * @return Define the connector resource.
     */
    public suspend fun getConnector(argument: suspend GetConnectorPlainArgsBuilder.() -> Unit):
        GetConnectorResult {
        val builder = GetConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectorResultToKotlin(getConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets properties of a SAP monitor for the specified subscription, resource group, and resource name.
     * Azure REST API version: 2023-04-01.
     * @param argument null
     * @return SAP monitor info on Azure (ARM properties and SAP monitor properties)
     */
    public suspend fun getMonitor(argument: GetMonitorPlainArgs): GetMonitorResult =
        getMonitorResultToKotlin(getMonitorPlain(argument.toJava()).await())

    /**
     * @see [getMonitor].
     * @param monitorName Name of the SAP monitor resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return SAP monitor info on Azure (ARM properties and SAP monitor properties)
     */
    public suspend fun getMonitor(monitorName: String, resourceGroupName: String): GetMonitorResult {
        val argument = GetMonitorPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return getMonitorResultToKotlin(getMonitorPlain(argument.toJava()).await())
    }

    /**
     * @see [getMonitor].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;workloads&#46;kotlin&#46;inputs&#46;GetMonitorPlainArgs].
     * @return SAP monitor info on Azure (ARM properties and SAP monitor properties)
     */
    public suspend fun getMonitor(argument: suspend GetMonitorPlainArgsBuilder.() -> Unit):
        GetMonitorResult {
        val builder = GetMonitorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMonitorResultToKotlin(getMonitorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets properties of a provider instance for the specified subscription, resource group, SAP monitor name, and resource name.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-10-01-preview.
     * @param argument null
     * @return A provider instance associated with SAP monitor.
     */
    public suspend fun getProviderInstance(argument: GetProviderInstancePlainArgs):
        GetProviderInstanceResult =
        getProviderInstanceResultToKotlin(getProviderInstancePlain(argument.toJava()).await())

    /**
     * @see [getProviderInstance].
     * @param monitorName Name of the SAP monitor resource.
     * @param providerInstanceName Name of the provider instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A provider instance associated with SAP monitor.
     */
    public suspend fun getProviderInstance(
        monitorName: String,
        providerInstanceName: String,
        resourceGroupName: String,
    ): GetProviderInstanceResult {
        val argument = GetProviderInstancePlainArgs(
            monitorName = monitorName,
            providerInstanceName = providerInstanceName,
            resourceGroupName = resourceGroupName,
        )
        return getProviderInstanceResultToKotlin(getProviderInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getProviderInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;workloads&#46;kotlin&#46;inputs&#46;GetProviderInstancePlainArgs].
     * @return A provider instance associated with SAP monitor.
     */
    public suspend
    fun getProviderInstance(argument: suspend GetProviderInstancePlainArgsBuilder.() -> Unit):
        GetProviderInstanceResult {
        val builder = GetProviderInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProviderInstanceResultToKotlin(getProviderInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the SAP Application Server Instance corresponding to the Virtual Instance for SAP solutions resource.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-12-01-preview, 2023-10-01-preview.
     * @param argument null
     * @return Define the SAP Application Server Instance resource.
     */
    public suspend
    fun getSAPApplicationServerInstance(argument: GetSAPApplicationServerInstancePlainArgs):
        GetSAPApplicationServerInstanceResult =
        getSAPApplicationServerInstanceResultToKotlin(getSAPApplicationServerInstancePlain(argument.toJava()).await())

    /**
     * @see [getSAPApplicationServerInstance].
     * @param applicationInstanceName The name of SAP Application Server instance resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sapVirtualInstanceName The name of the Virtual Instances for SAP solutions resource
     * @return Define the SAP Application Server Instance resource.
     */
    public suspend fun getSAPApplicationServerInstance(
        applicationInstanceName: String,
        resourceGroupName: String,
        sapVirtualInstanceName: String,
    ): GetSAPApplicationServerInstanceResult {
        val argument = GetSAPApplicationServerInstancePlainArgs(
            applicationInstanceName = applicationInstanceName,
            resourceGroupName = resourceGroupName,
            sapVirtualInstanceName = sapVirtualInstanceName,
        )
        return getSAPApplicationServerInstanceResultToKotlin(getSAPApplicationServerInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getSAPApplicationServerInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;workloads&#46;kotlin&#46;inputs&#46;GetSAPApplicationServerInstancePlainArgs].
     * @return Define the SAP Application Server Instance resource.
     */
    public suspend
    fun getSAPApplicationServerInstance(argument: suspend GetSAPApplicationServerInstancePlainArgsBuilder.() -> Unit):
        GetSAPApplicationServerInstanceResult {
        val builder = GetSAPApplicationServerInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSAPApplicationServerInstanceResultToKotlin(getSAPApplicationServerInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the recommended SAP Availability Zone Pair Details for your region.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-12-01-preview, 2022-11-01-preview, 2023-10-01-preview.
     * @param argument null
     * @return The list of supported availability zone pairs which are part of SAP HA deployment.
     */
    public suspend
    fun getSAPAvailabilityZoneDetails(argument: GetSAPAvailabilityZoneDetailsPlainArgs):
        GetSAPAvailabilityZoneDetailsResult =
        getSAPAvailabilityZoneDetailsResultToKotlin(getSAPAvailabilityZoneDetailsPlain(argument.toJava()).await())

    /**
     * @see [getSAPAvailabilityZoneDetails].
     * @param appLocation The geo-location where the SAP resources will be created.
     * @param databaseType The database type. Eg: HANA, DB2, etc
     * @param location The name of Azure region.
     * @param sapProduct Defines the SAP Product type.
     * @return The list of supported availability zone pairs which are part of SAP HA deployment.
     */
    public suspend fun getSAPAvailabilityZoneDetails(
        appLocation: String,
        databaseType: Either<String, SAPDatabaseType>,
        location: String,
        sapProduct: Either<String, SAPProductType>,
    ): GetSAPAvailabilityZoneDetailsResult {
        val argument = GetSAPAvailabilityZoneDetailsPlainArgs(
            appLocation = appLocation,
            databaseType = databaseType,
            location = location,
            sapProduct = sapProduct,
        )
        return getSAPAvailabilityZoneDetailsResultToKotlin(getSAPAvailabilityZoneDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSAPAvailabilityZoneDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;workloads&#46;kotlin&#46;inputs&#46;GetSAPAvailabilityZoneDetailsPlainArgs].
     * @return The list of supported availability zone pairs which are part of SAP HA deployment.
     */
    public suspend
    fun getSAPAvailabilityZoneDetails(argument: suspend GetSAPAvailabilityZoneDetailsPlainArgsBuilder.() -> Unit):
        GetSAPAvailabilityZoneDetailsResult {
        val builder = GetSAPAvailabilityZoneDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSAPAvailabilityZoneDetailsResultToKotlin(getSAPAvailabilityZoneDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the SAP Central Services Instance resource.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-10-01-preview.
     * @param argument null
     * @return Define the SAP Central Services Instance resource.
     */
    public suspend fun getSAPCentralInstance(argument: GetSAPCentralInstancePlainArgs):
        GetSAPCentralInstanceResult =
        getSAPCentralInstanceResultToKotlin(getSAPCentralInstancePlain(argument.toJava()).await())

    /**
     * @see [getSAPCentralInstance].
     * @param centralInstanceName Central Services Instance resource name string modeled as parameter for auto generation to work correctly.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sapVirtualInstanceName The name of the Virtual Instances for SAP solutions resource
     * @return Define the SAP Central Services Instance resource.
     */
    public suspend fun getSAPCentralInstance(
        centralInstanceName: String,
        resourceGroupName: String,
        sapVirtualInstanceName: String,
    ): GetSAPCentralInstanceResult {
        val argument = GetSAPCentralInstancePlainArgs(
            centralInstanceName = centralInstanceName,
            resourceGroupName = resourceGroupName,
            sapVirtualInstanceName = sapVirtualInstanceName,
        )
        return getSAPCentralInstanceResultToKotlin(getSAPCentralInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getSAPCentralInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;workloads&#46;kotlin&#46;inputs&#46;GetSAPCentralInstancePlainArgs].
     * @return Define the SAP Central Services Instance resource.
     */
    public suspend
    fun getSAPCentralInstance(argument: suspend GetSAPCentralInstancePlainArgsBuilder.() -> Unit):
        GetSAPCentralInstanceResult {
        val builder = GetSAPCentralInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSAPCentralInstanceResultToKotlin(getSAPCentralInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the SAP Database Instance resource.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-10-01-preview.
     * @param argument null
     * @return Define the Database resource.
     */
    public suspend fun getSAPDatabaseInstance(argument: GetSAPDatabaseInstancePlainArgs):
        GetSAPDatabaseInstanceResult =
        getSAPDatabaseInstanceResultToKotlin(getSAPDatabaseInstancePlain(argument.toJava()).await())

    /**
     * @see [getSAPDatabaseInstance].
     * @param databaseInstanceName Database resource name string modeled as parameter for auto generation to work correctly.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sapVirtualInstanceName The name of the Virtual Instances for SAP solutions resource
     * @return Define the Database resource.
     */
    public suspend fun getSAPDatabaseInstance(
        databaseInstanceName: String,
        resourceGroupName: String,
        sapVirtualInstanceName: String,
    ): GetSAPDatabaseInstanceResult {
        val argument = GetSAPDatabaseInstancePlainArgs(
            databaseInstanceName = databaseInstanceName,
            resourceGroupName = resourceGroupName,
            sapVirtualInstanceName = sapVirtualInstanceName,
        )
        return getSAPDatabaseInstanceResultToKotlin(getSAPDatabaseInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getSAPDatabaseInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;workloads&#46;kotlin&#46;inputs&#46;GetSAPDatabaseInstancePlainArgs].
     * @return Define the Database resource.
     */
    public suspend
    fun getSAPDatabaseInstance(argument: suspend GetSAPDatabaseInstancePlainArgsBuilder.() -> Unit):
        GetSAPDatabaseInstanceResult {
        val builder = GetSAPDatabaseInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSAPDatabaseInstanceResultToKotlin(getSAPDatabaseInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the SAP Disk Configuration Layout prod/non-prod SAP System.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-12-01-preview, 2022-11-01-preview, 2023-10-01-preview.
     * @param argument null
     * @return The list of disk configuration for vmSku which are part of SAP deployment.
     */
    public suspend fun getSAPDiskConfigurations(argument: GetSAPDiskConfigurationsPlainArgs):
        GetSAPDiskConfigurationsResult =
        getSAPDiskConfigurationsResultToKotlin(getSAPDiskConfigurationsPlain(argument.toJava()).await())

    /**
     * @see [getSAPDiskConfigurations].
     * @param appLocation The geo-location where the SAP resources will be created.
     * @param databaseType The database type. Eg: HANA, DB2, etc
     * @param dbVmSku The VM SKU for database instance.
     * @param deploymentType The deployment type. Eg: SingleServer/ThreeTier
     * @param environment Defines the environment type - Production/Non Production.
     * @param location The name of Azure region.
     * @param sapProduct Defines the SAP Product type.
     * @return The list of disk configuration for vmSku which are part of SAP deployment.
     */
    public suspend fun getSAPDiskConfigurations(
        appLocation: String,
        databaseType: Either<String, SAPDatabaseType>,
        dbVmSku: String,
        deploymentType: Either<String, SAPDeploymentType>,
        environment: Either<String, SAPEnvironmentType>,
        location: String,
        sapProduct: Either<String, SAPProductType>,
    ): GetSAPDiskConfigurationsResult {
        val argument = GetSAPDiskConfigurationsPlainArgs(
            appLocation = appLocation,
            databaseType = databaseType,
            dbVmSku = dbVmSku,
            deploymentType = deploymentType,
            environment = environment,
            location = location,
            sapProduct = sapProduct,
        )
        return getSAPDiskConfigurationsResultToKotlin(getSAPDiskConfigurationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSAPDiskConfigurations].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;workloads&#46;kotlin&#46;inputs&#46;GetSAPDiskConfigurationsPlainArgs].
     * @return The list of disk configuration for vmSku which are part of SAP deployment.
     */
    public suspend
    fun getSAPDiskConfigurations(argument: suspend GetSAPDiskConfigurationsPlainArgsBuilder.() -> Unit):
        GetSAPDiskConfigurationsResult {
        val builder = GetSAPDiskConfigurationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSAPDiskConfigurationsResultToKotlin(getSAPDiskConfigurationsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get SAP sizing recommendations by providing input SAPS for application tier and memory required for database tier
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-12-01-preview, 2022-11-01-preview, 2023-10-01-preview.
     * @param argument null
     * @return The SAP sizing recommendation result.
     */
    public suspend fun getSAPSizingRecommendations(argument: GetSAPSizingRecommendationsPlainArgs):
        GetSAPSizingRecommendationsResult =
        getSAPSizingRecommendationsResultToKotlin(getSAPSizingRecommendationsPlain(argument.toJava()).await())

    /**
     * @see [getSAPSizingRecommendations].
     * @param appLocation The geo-location where the resource is to be created.
     * @param databaseType The database type.
     * @param dbMemory The database memory configuration.
     * @param dbScaleMethod The DB scale method.
     * @param deploymentType The deployment type. Eg: SingleServer/ThreeTier
     * @param environment Defines the environment type - Production/Non Production.
     * @param highAvailabilityType The high availability type.
     * @param location The name of Azure region.
     * @param sapProduct Defines the SAP Product type.
     * @param saps The SAP Application Performance Standard measurement.
     * @return The SAP sizing recommendation result.
     */
    public suspend fun getSAPSizingRecommendations(
        appLocation: String,
        databaseType: Either<String, SAPDatabaseType>,
        dbMemory: Double,
        dbScaleMethod: Either<String, SAPDatabaseScaleMethod>? = null,
        deploymentType: Either<String, SAPDeploymentType>,
        environment: Either<String, SAPEnvironmentType>,
        highAvailabilityType: Either<String, SAPHighAvailabilityType>? = null,
        location: String,
        sapProduct: Either<String, SAPProductType>,
        saps: Double,
    ): GetSAPSizingRecommendationsResult {
        val argument = GetSAPSizingRecommendationsPlainArgs(
            appLocation = appLocation,
            databaseType = databaseType,
            dbMemory = dbMemory,
            dbScaleMethod = dbScaleMethod,
            deploymentType = deploymentType,
            environment = environment,
            highAvailabilityType = highAvailabilityType,
            location = location,
            sapProduct = sapProduct,
            saps = saps,
        )
        return getSAPSizingRecommendationsResultToKotlin(getSAPSizingRecommendationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSAPSizingRecommendations].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;workloads&#46;kotlin&#46;inputs&#46;GetSAPSizingRecommendationsPlainArgs].
     * @return The SAP sizing recommendation result.
     */
    public suspend
    fun getSAPSizingRecommendations(argument: suspend GetSAPSizingRecommendationsPlainArgsBuilder.() -> Unit):
        GetSAPSizingRecommendationsResult {
        val builder = GetSAPSizingRecommendationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSAPSizingRecommendationsResultToKotlin(getSAPSizingRecommendationsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a list of SAP supported SKUs for ASCS, Application and Database tier.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-12-01-preview, 2022-11-01-preview, 2023-10-01-preview.
     * @param argument null
     * @return The list of supported SKUs for different resources which are part of SAP deployment.
     */
    public suspend fun getSAPSupportedSku(argument: GetSAPSupportedSkuPlainArgs):
        GetSAPSupportedSkuResult =
        getSAPSupportedSkuResultToKotlin(getSAPSupportedSkuPlain(argument.toJava()).await())

    /**
     * @see [getSAPSupportedSku].
     * @param appLocation The geo-location where the resource is to be created.
     * @param databaseType The database type. Eg: HANA, DB2, etc
     * @param deploymentType The deployment type. Eg: SingleServer/ThreeTier
     * @param environment Defines the environment type - Production/Non Production.
     * @param highAvailabilityType The high availability type.
     * @param location The name of Azure region.
     * @param sapProduct Defines the SAP Product type.
     * @return The list of supported SKUs for different resources which are part of SAP deployment.
     */
    public suspend fun getSAPSupportedSku(
        appLocation: String,
        databaseType: Either<String, SAPDatabaseType>,
        deploymentType: Either<String, SAPDeploymentType>,
        environment: Either<String, SAPEnvironmentType>,
        highAvailabilityType: Either<String, SAPHighAvailabilityType>? = null,
        location: String,
        sapProduct: Either<String, SAPProductType>,
    ): GetSAPSupportedSkuResult {
        val argument = GetSAPSupportedSkuPlainArgs(
            appLocation = appLocation,
            databaseType = databaseType,
            deploymentType = deploymentType,
            environment = environment,
            highAvailabilityType = highAvailabilityType,
            location = location,
            sapProduct = sapProduct,
        )
        return getSAPSupportedSkuResultToKotlin(getSAPSupportedSkuPlain(argument.toJava()).await())
    }

    /**
     * @see [getSAPSupportedSku].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;workloads&#46;kotlin&#46;inputs&#46;GetSAPSupportedSkuPlainArgs].
     * @return The list of supported SKUs for different resources which are part of SAP deployment.
     */
    public suspend
    fun getSAPSupportedSku(argument: suspend GetSAPSupportedSkuPlainArgsBuilder.() -> Unit):
        GetSAPSupportedSkuResult {
        val builder = GetSAPSupportedSkuPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSAPSupportedSkuResultToKotlin(getSAPSupportedSkuPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Virtual Instance for SAP solutions resource
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-10-01-preview.
     * @param argument null
     * @return Define the Virtual Instance for SAP solutions resource.
     */
    public suspend fun getSAPVirtualInstance(argument: GetSAPVirtualInstancePlainArgs):
        GetSAPVirtualInstanceResult =
        getSAPVirtualInstanceResultToKotlin(getSAPVirtualInstancePlain(argument.toJava()).await())

    /**
     * @see [getSAPVirtualInstance].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sapVirtualInstanceName The name of the Virtual Instances for SAP solutions resource
     * @return Define the Virtual Instance for SAP solutions resource.
     */
    public suspend fun getSAPVirtualInstance(
        resourceGroupName: String,
        sapVirtualInstanceName: String,
    ): GetSAPVirtualInstanceResult {
        val argument = GetSAPVirtualInstancePlainArgs(
            resourceGroupName = resourceGroupName,
            sapVirtualInstanceName = sapVirtualInstanceName,
        )
        return getSAPVirtualInstanceResultToKotlin(getSAPVirtualInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getSAPVirtualInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;workloads&#46;kotlin&#46;inputs&#46;GetSAPVirtualInstancePlainArgs].
     * @return Define the Virtual Instance for SAP solutions resource.
     */
    public suspend
    fun getSAPVirtualInstance(argument: suspend GetSAPVirtualInstancePlainArgsBuilder.() -> Unit):
        GetSAPVirtualInstanceResult {
        val builder = GetSAPVirtualInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSAPVirtualInstanceResultToKotlin(getSAPVirtualInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets configuration values for Single Pane Of Glass for SAP monitor for the specified subscription, resource group, and resource name.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-10-01-preview.
     * @param argument null
     * @return configuration associated with SAP Landscape Monitor Dashboard.
     */
    public suspend fun getSapLandscapeMonitor(argument: GetSapLandscapeMonitorPlainArgs):
        GetSapLandscapeMonitorResult =
        getSapLandscapeMonitorResultToKotlin(getSapLandscapeMonitorPlain(argument.toJava()).await())

    /**
     * @see [getSapLandscapeMonitor].
     * @param monitorName Name of the SAP monitor resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return configuration associated with SAP Landscape Monitor Dashboard.
     */
    public suspend fun getSapLandscapeMonitor(monitorName: String, resourceGroupName: String):
        GetSapLandscapeMonitorResult {
        val argument = GetSapLandscapeMonitorPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return getSapLandscapeMonitorResultToKotlin(getSapLandscapeMonitorPlain(argument.toJava()).await())
    }

    /**
     * @see [getSapLandscapeMonitor].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;workloads&#46;kotlin&#46;inputs&#46;GetSapLandscapeMonitorPlainArgs].
     * @return configuration associated with SAP Landscape Monitor Dashboard.
     */
    public suspend
    fun getSapLandscapeMonitor(argument: suspend GetSapLandscapeMonitorPlainArgsBuilder.() -> Unit):
        GetSapLandscapeMonitorResult {
        val builder = GetSapLandscapeMonitorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSapLandscapeMonitorResultToKotlin(getSapLandscapeMonitorPlain(builtArgument.toJava()).await())
    }
}
