@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DatabaseConfigurationArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SAPDatabaseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Gets or sets the database configuration.
 * @property databaseType The database type.
 * @property diskConfiguration Gets or sets the disk configuration.
 * @property instanceCount The number of database VMs.
 * @property subnetId The subnet id.
 * @property virtualMachineConfiguration Gets or sets the virtual machine configuration.
 */
public data class DatabaseConfigurationArgs(
    public val databaseType: Output<Either<String, SAPDatabaseType>>? = null,
    public val diskConfiguration: Output<DiskConfigurationArgs>? = null,
    public val instanceCount: Output<Double>,
    public val subnetId: Output<String>,
    public val virtualMachineConfiguration: Output<VirtualMachineConfigurationArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DatabaseConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DatabaseConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.DatabaseConfigurationArgs.builder()
            .databaseType(
                databaseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .diskConfiguration(diskConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instanceCount(instanceCount.applyValue({ args0 -> args0 }))
            .subnetId(subnetId.applyValue({ args0 -> args0 }))
            .virtualMachineConfiguration(
                virtualMachineConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DatabaseConfigurationArgs].
 */
@PulumiTagMarker
public class DatabaseConfigurationArgsBuilder internal constructor() {
    private var databaseType: Output<Either<String, SAPDatabaseType>>? = null

    private var diskConfiguration: Output<DiskConfigurationArgs>? = null

    private var instanceCount: Output<Double>? = null

    private var subnetId: Output<String>? = null

    private var virtualMachineConfiguration: Output<VirtualMachineConfigurationArgs>? = null

    /**
     * @param value The database type.
     */
    @JvmName("ubdfinnkelulgxjl")
    public suspend fun databaseType(`value`: Output<Either<String, SAPDatabaseType>>) {
        this.databaseType = value
    }

    /**
     * @param value Gets or sets the disk configuration.
     */
    @JvmName("tcicekdddvfvwapg")
    public suspend fun diskConfiguration(`value`: Output<DiskConfigurationArgs>) {
        this.diskConfiguration = value
    }

    /**
     * @param value The number of database VMs.
     */
    @JvmName("inkmmcopvioakvrh")
    public suspend fun instanceCount(`value`: Output<Double>) {
        this.instanceCount = value
    }

    /**
     * @param value The subnet id.
     */
    @JvmName("kkdqofcuhglddwfm")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Gets or sets the virtual machine configuration.
     */
    @JvmName("rqrmetonjvuoemjg")
    public suspend fun virtualMachineConfiguration(`value`: Output<VirtualMachineConfigurationArgs>) {
        this.virtualMachineConfiguration = value
    }

    /**
     * @param value The database type.
     */
    @JvmName("dgejxtopuvckadgm")
    public suspend fun databaseType(`value`: Either<String, SAPDatabaseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseType = mapped
    }

    /**
     * @param value The database type.
     */
    @JvmName("ltjfcdoytfmbnwtr")
    public fun databaseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPDatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseType = mapped
    }

    /**
     * @param value The database type.
     */
    @JvmName("pmismvvtximdnwhk")
    public fun databaseType(`value`: SAPDatabaseType) {
        val toBeMapped = Either.ofRight<String, SAPDatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseType = mapped
    }

    /**
     * @param value Gets or sets the disk configuration.
     */
    @JvmName("xxcpaexrthdxluda")
    public suspend fun diskConfiguration(`value`: DiskConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskConfiguration = mapped
    }

    /**
     * @param argument Gets or sets the disk configuration.
     */
    @JvmName("svioehmwssqdjnbn")
    public suspend fun diskConfiguration(argument: suspend DiskConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DiskConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskConfiguration = mapped
    }

    /**
     * @param value The number of database VMs.
     */
    @JvmName("rnrvstihvxfqwcqs")
    public suspend fun instanceCount(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value The subnet id.
     */
    @JvmName("jqnqfybauehamfms")
    public suspend fun subnetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Gets or sets the virtual machine configuration.
     */
    @JvmName("wcastsrinkbutpjh")
    public suspend fun virtualMachineConfiguration(`value`: VirtualMachineConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachineConfiguration = mapped
    }

    /**
     * @param argument Gets or sets the virtual machine configuration.
     */
    @JvmName("lttpxyargubosowe")
    public suspend
    fun virtualMachineConfiguration(argument: suspend VirtualMachineConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualMachineConfiguration = mapped
    }

    internal fun build(): DatabaseConfigurationArgs = DatabaseConfigurationArgs(
        databaseType = databaseType,
        diskConfiguration = diskConfiguration,
        instanceCount = instanceCount ?: throw PulumiNullFieldException("instanceCount"),
        subnetId = subnetId ?: throw PulumiNullFieldException("subnetId"),
        virtualMachineConfiguration = virtualMachineConfiguration ?: throw
            PulumiNullFieldException("virtualMachineConfiguration"),
    )
}
