@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DatabaseServerFullResourceNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
 * @property availabilitySetName The full name for availability set. In case name is not provided, it will be defaulted to {SID}-DB-AvSet.
 * @property loadBalancer The resource names object for load balancer and related resources.
 * @property virtualMachines The list of virtual machine naming details.
 */
public data class DatabaseServerFullResourceNamesArgs(
    public val availabilitySetName: Output<String>? = null,
    public val loadBalancer: Output<LoadBalancerResourceNamesArgs>? = null,
    public val virtualMachines: Output<List<VirtualMachineResourceNamesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DatabaseServerFullResourceNamesArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DatabaseServerFullResourceNamesArgs =
        com.pulumi.azurenative.workloads.inputs.DatabaseServerFullResourceNamesArgs.builder()
            .availabilitySetName(availabilitySetName?.applyValue({ args0 -> args0 }))
            .loadBalancer(loadBalancer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .virtualMachines(
                virtualMachines?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DatabaseServerFullResourceNamesArgs].
 */
@PulumiTagMarker
public class DatabaseServerFullResourceNamesArgsBuilder internal constructor() {
    private var availabilitySetName: Output<String>? = null

    private var loadBalancer: Output<LoadBalancerResourceNamesArgs>? = null

    private var virtualMachines: Output<List<VirtualMachineResourceNamesArgs>>? = null

    /**
     * @param value The full name for availability set. In case name is not provided, it will be defaulted to {SID}-DB-AvSet.
     */
    @JvmName("jdadlqxqupdccxtu")
    public suspend fun availabilitySetName(`value`: Output<String>) {
        this.availabilitySetName = value
    }

    /**
     * @param value The resource names object for load balancer and related resources.
     */
    @JvmName("lnbmljjnkuqoajpu")
    public suspend fun loadBalancer(`value`: Output<LoadBalancerResourceNamesArgs>) {
        this.loadBalancer = value
    }

    /**
     * @param value The list of virtual machine naming details.
     */
    @JvmName("jqhpfqyxnnodowiw")
    public suspend fun virtualMachines(`value`: Output<List<VirtualMachineResourceNamesArgs>>) {
        this.virtualMachines = value
    }

    @JvmName("xsyrxpoxkiwdgiua")
    public suspend fun virtualMachines(vararg values: Output<VirtualMachineResourceNamesArgs>) {
        this.virtualMachines = Output.all(values.asList())
    }

    /**
     * @param values The list of virtual machine naming details.
     */
    @JvmName("wyuhnsfujeqddurn")
    public suspend fun virtualMachines(values: List<Output<VirtualMachineResourceNamesArgs>>) {
        this.virtualMachines = Output.all(values)
    }

    /**
     * @param value The full name for availability set. In case name is not provided, it will be defaulted to {SID}-DB-AvSet.
     */
    @JvmName("ukqsmtejtyapiboe")
    public suspend fun availabilitySetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilitySetName = mapped
    }

    /**
     * @param value The resource names object for load balancer and related resources.
     */
    @JvmName("csttsfrijajacyph")
    public suspend fun loadBalancer(`value`: LoadBalancerResourceNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancer = mapped
    }

    /**
     * @param argument The resource names object for load balancer and related resources.
     */
    @JvmName("ryrkivdwofowdaee")
    public suspend
    fun loadBalancer(argument: suspend LoadBalancerResourceNamesArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerResourceNamesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadBalancer = mapped
    }

    /**
     * @param value The list of virtual machine naming details.
     */
    @JvmName("pwnerdovvyhotbjb")
    public suspend fun virtualMachines(`value`: List<VirtualMachineResourceNamesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachines = mapped
    }

    /**
     * @param argument The list of virtual machine naming details.
     */
    @JvmName("qdrxcoeecifebcsv")
    public suspend
    fun virtualMachines(argument: List<suspend VirtualMachineResourceNamesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineResourceNamesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param argument The list of virtual machine naming details.
     */
    @JvmName("ggbupspbglbnlqoi")
    public suspend fun virtualMachines(
        vararg
        argument: suspend VirtualMachineResourceNamesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachineResourceNamesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param argument The list of virtual machine naming details.
     */
    @JvmName("tikrjbckuqbpjrld")
    public suspend
    fun virtualMachines(argument: suspend VirtualMachineResourceNamesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachineResourceNamesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param values The list of virtual machine naming details.
     */
    @JvmName("xnprnvmcaujfumbg")
    public suspend fun virtualMachines(vararg values: VirtualMachineResourceNamesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachines = mapped
    }

    internal fun build(): DatabaseServerFullResourceNamesArgs = DatabaseServerFullResourceNamesArgs(
        availabilitySetName = availabilitySetName,
        loadBalancer = loadBalancer,
        virtualMachines = virtualMachines,
    )
}
