@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Day of the week.
 * @property date Date of the month
 * @property isLast Whether Date is last date of month
 */
public data class DayArgs(
    public val date: Output<Int>? = null,
    public val isLast: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DayArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DayArgs =
        com.pulumi.azurenative.workloads.inputs.DayArgs.builder()
            .date(date?.applyValue({ args0 -> args0 }))
            .isLast(isLast?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DayArgs].
 */
@PulumiTagMarker
public class DayArgsBuilder internal constructor() {
    private var date: Output<Int>? = null

    private var isLast: Output<Boolean>? = null

    /**
     * @param value Date of the month
     */
    @JvmName("nadpbfthhnoboimy")
    public suspend fun date(`value`: Output<Int>) {
        this.date = value
    }

    /**
     * @param value Whether Date is last date of month
     */
    @JvmName("auoyaihcwjbdfscx")
    public suspend fun isLast(`value`: Output<Boolean>) {
        this.isLast = value
    }

    /**
     * @param value Date of the month
     */
    @JvmName("litiygcferytyhbo")
    public suspend fun date(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.date = mapped
    }

    /**
     * @param value Whether Date is last date of month
     */
    @JvmName("qpsbbuctmdcmhhlo")
    public suspend fun isLast(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isLast = mapped
    }

    internal fun build(): DayArgs = DayArgs(
        date = date,
        isLast = isLast,
    )
}
