@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DiskConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Disk Configuration Details.
 * @property diskVolumeConfigurations The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume : ['backup'].
 */
public data class DiskConfigurationArgs(
    public val diskVolumeConfigurations: Output<Map<String, DiskVolumeConfigurationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DiskConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DiskConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.DiskConfigurationArgs.builder()
            .diskVolumeConfigurations(
                diskVolumeConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DiskConfigurationArgs].
 */
@PulumiTagMarker
public class DiskConfigurationArgsBuilder internal constructor() {
    private var diskVolumeConfigurations: Output<Map<String, DiskVolumeConfigurationArgs>>? = null

    /**
     * @param value The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume : ['backup'].
     */
    @JvmName("vqwjjgfauyufrvsi")
    public suspend
    fun diskVolumeConfigurations(`value`: Output<Map<String, DiskVolumeConfigurationArgs>>) {
        this.diskVolumeConfigurations = value
    }

    /**
     * @param value The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume : ['backup'].
     */
    @JvmName("rjkeccomeawyuubo")
    public suspend fun diskVolumeConfigurations(`value`: Map<String, DiskVolumeConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskVolumeConfigurations = mapped
    }

    /**
     * @param argument The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume : ['backup'].
     */
    @JvmName("saqioraypmoobjiv")
    public suspend fun diskVolumeConfigurations(
        vararg
        argument: Pair<String, suspend DiskVolumeConfigurationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                DiskVolumeConfigurationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.diskVolumeConfigurations = mapped
    }

    /**
     * @param values The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume : ['backup'].
     */
    @JvmName("wmlekcdqndpkpcwa")
    public fun diskVolumeConfigurations(vararg values: Pair<String, DiskVolumeConfigurationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskVolumeConfigurations = mapped
    }

    internal fun build(): DiskConfigurationArgs = DiskConfigurationArgs(
        diskVolumeConfigurations = diskVolumeConfigurations,
    )
}
