@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetSAPDiskConfigurationsPlainArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SAPDatabaseType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPDeploymentType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPEnvironmentType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPProductType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appLocation The geo-location where the SAP resources will be created.
 * @property databaseType The database type. Eg: HANA, DB2, etc
 * @property dbVmSku The VM SKU for database instance.
 * @property deploymentType The deployment type. Eg: SingleServer/ThreeTier
 * @property environment Defines the environment type - Production/Non Production.
 * @property location The name of Azure region.
 * @property sapProduct Defines the SAP Product type.
 */
public data class GetSAPDiskConfigurationsPlainArgs(
    public val appLocation: String,
    public val databaseType: Either<String, SAPDatabaseType>,
    public val dbVmSku: String,
    public val deploymentType: Either<String, SAPDeploymentType>,
    public val environment: Either<String, SAPEnvironmentType>,
    public val location: String,
    public val sapProduct: Either<String, SAPProductType>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetSAPDiskConfigurationsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.GetSAPDiskConfigurationsPlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetSAPDiskConfigurationsPlainArgs.builder()
            .appLocation(appLocation.let({ args0 -> args0 }))
            .databaseType(
                databaseType.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dbVmSku(dbVmSku.let({ args0 -> args0 }))
            .deploymentType(
                deploymentType.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .environment(
                environment.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location.let({ args0 -> args0 }))
            .sapProduct(
                sapProduct.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetSAPDiskConfigurationsPlainArgs].
 */
@PulumiTagMarker
public class GetSAPDiskConfigurationsPlainArgsBuilder internal constructor() {
    private var appLocation: String? = null

    private var databaseType: Either<String, SAPDatabaseType>? = null

    private var dbVmSku: String? = null

    private var deploymentType: Either<String, SAPDeploymentType>? = null

    private var environment: Either<String, SAPEnvironmentType>? = null

    private var location: String? = null

    private var sapProduct: Either<String, SAPProductType>? = null

    /**
     * @param value The geo-location where the SAP resources will be created.
     */
    @JvmName("oxoedsbhifvbrsud")
    public suspend fun appLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appLocation = mapped
    }

    /**
     * @param value The database type. Eg: HANA, DB2, etc
     */
    @JvmName("mkgkvqwfhtfrhcmg")
    public suspend fun databaseType(`value`: Either<String, SAPDatabaseType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value The database type. Eg: HANA, DB2, etc
     */
    @JvmName("qpgmygrovgtrinwb")
    public fun databaseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPDatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value The database type. Eg: HANA, DB2, etc
     */
    @JvmName("xefgjqfbnvtkntdu")
    public fun databaseType(`value`: SAPDatabaseType) {
        val toBeMapped = Either.ofRight<String, SAPDatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value The VM SKU for database instance.
     */
    @JvmName("lrsjwheseahpslwo")
    public suspend fun dbVmSku(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbVmSku = mapped
    }

    /**
     * @param value The deployment type. Eg: SingleServer/ThreeTier
     */
    @JvmName("hwmwgafwaknqxcri")
    public suspend fun deploymentType(`value`: Either<String, SAPDeploymentType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentType = mapped
    }

    /**
     * @param value The deployment type. Eg: SingleServer/ThreeTier
     */
    @JvmName("dekvytpyppfpufoq")
    public fun deploymentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPDeploymentType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentType = mapped
    }

    /**
     * @param value The deployment type. Eg: SingleServer/ThreeTier
     */
    @JvmName("omsfveutidgguhjl")
    public fun deploymentType(`value`: SAPDeploymentType) {
        val toBeMapped = Either.ofRight<String, SAPDeploymentType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentType = mapped
    }

    /**
     * @param value Defines the environment type - Production/Non Production.
     */
    @JvmName("ylkxqnuxqdcwxiab")
    public suspend fun environment(`value`: Either<String, SAPEnvironmentType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environment = mapped
    }

    /**
     * @param value Defines the environment type - Production/Non Production.
     */
    @JvmName("spmladqidpprwiia")
    public fun environment(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPEnvironmentType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environment = mapped
    }

    /**
     * @param value Defines the environment type - Production/Non Production.
     */
    @JvmName("eymgpjkjeutrowxx")
    public fun environment(`value`: SAPEnvironmentType) {
        val toBeMapped = Either.ofRight<String, SAPEnvironmentType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environment = mapped
    }

    /**
     * @param value The name of Azure region.
     */
    @JvmName("rwcxehupmukkdeyb")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.location = mapped
    }

    /**
     * @param value Defines the SAP Product type.
     */
    @JvmName("bnalowqnmmtmnpbw")
    public suspend fun sapProduct(`value`: Either<String, SAPProductType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapProduct = mapped
    }

    /**
     * @param value Defines the SAP Product type.
     */
    @JvmName("apgjkejdmokbobhl")
    public fun sapProduct(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPProductType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapProduct = mapped
    }

    /**
     * @param value Defines the SAP Product type.
     */
    @JvmName("ykaulguxpfdcadis")
    public fun sapProduct(`value`: SAPProductType) {
        val toBeMapped = Either.ofRight<String, SAPProductType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapProduct = mapped
    }

    internal fun build(): GetSAPDiskConfigurationsPlainArgs = GetSAPDiskConfigurationsPlainArgs(
        appLocation = appLocation ?: throw PulumiNullFieldException("appLocation"),
        databaseType = databaseType ?: throw PulumiNullFieldException("databaseType"),
        dbVmSku = dbVmSku ?: throw PulumiNullFieldException("dbVmSku"),
        deploymentType = deploymentType ?: throw PulumiNullFieldException("deploymentType"),
        environment = environment ?: throw PulumiNullFieldException("environment"),
        location = location ?: throw PulumiNullFieldException("location"),
        sapProduct = sapProduct ?: throw PulumiNullFieldException("sapProduct"),
    )
}
