@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.HanaDbProviderInstancePropertiesArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SslPreference
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets or sets the provider properties.
 * @property dbName Gets or sets the hana database name.
 * @property dbPassword Gets or sets the database password.
 * @property dbPasswordUri Gets or sets the key vault URI to secret with the database password.
 * @property dbUsername Gets or sets the database user name.
 * @property hostname Gets or sets the target virtual machine size.
 * @property instanceNumber Gets or sets the database instance number.
 * @property providerType The provider type. For example, the value can be SapHana.
 * Expected value is 'SapHana'.
 * @property sapSid Gets or sets the SAP System Identifier.
 * @property sqlPort Gets or sets the database sql port.
 * @property sslCertificateUri Gets or sets the blob URI to SSL certificate for the DB.
 * @property sslHostNameInCertificate Gets or sets the hostname(s) in the SSL certificate.
 * @property sslPreference Gets or sets certificate preference if secure communication is enabled.
 */
public data class HanaDbProviderInstancePropertiesArgs(
    public val dbName: Output<String>? = null,
    public val dbPassword: Output<String>? = null,
    public val dbPasswordUri: Output<String>? = null,
    public val dbUsername: Output<String>? = null,
    public val hostname: Output<String>? = null,
    public val instanceNumber: Output<String>? = null,
    public val providerType: Output<String>,
    public val sapSid: Output<String>? = null,
    public val sqlPort: Output<String>? = null,
    public val sslCertificateUri: Output<String>? = null,
    public val sslHostNameInCertificate: Output<String>? = null,
    public val sslPreference: Output<Either<String, SslPreference>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.HanaDbProviderInstancePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.HanaDbProviderInstancePropertiesArgs =
        com.pulumi.azurenative.workloads.inputs.HanaDbProviderInstancePropertiesArgs.builder()
            .dbName(dbName?.applyValue({ args0 -> args0 }))
            .dbPassword(dbPassword?.applyValue({ args0 -> args0 }))
            .dbPasswordUri(dbPasswordUri?.applyValue({ args0 -> args0 }))
            .dbUsername(dbUsername?.applyValue({ args0 -> args0 }))
            .hostname(hostname?.applyValue({ args0 -> args0 }))
            .instanceNumber(instanceNumber?.applyValue({ args0 -> args0 }))
            .providerType(providerType.applyValue({ args0 -> args0 }))
            .sapSid(sapSid?.applyValue({ args0 -> args0 }))
            .sqlPort(sqlPort?.applyValue({ args0 -> args0 }))
            .sslCertificateUri(sslCertificateUri?.applyValue({ args0 -> args0 }))
            .sslHostNameInCertificate(sslHostNameInCertificate?.applyValue({ args0 -> args0 }))
            .sslPreference(
                sslPreference?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [HanaDbProviderInstancePropertiesArgs].
 */
@PulumiTagMarker
public class HanaDbProviderInstancePropertiesArgsBuilder internal constructor() {
    private var dbName: Output<String>? = null

    private var dbPassword: Output<String>? = null

    private var dbPasswordUri: Output<String>? = null

    private var dbUsername: Output<String>? = null

    private var hostname: Output<String>? = null

    private var instanceNumber: Output<String>? = null

    private var providerType: Output<String>? = null

    private var sapSid: Output<String>? = null

    private var sqlPort: Output<String>? = null

    private var sslCertificateUri: Output<String>? = null

    private var sslHostNameInCertificate: Output<String>? = null

    private var sslPreference: Output<Either<String, SslPreference>>? = null

    /**
     * @param value Gets or sets the hana database name.
     */
    @JvmName("ueceiqsphntdaase")
    public suspend fun dbName(`value`: Output<String>) {
        this.dbName = value
    }

    /**
     * @param value Gets or sets the database password.
     */
    @JvmName("igsnijprsmpqdupt")
    public suspend fun dbPassword(`value`: Output<String>) {
        this.dbPassword = value
    }

    /**
     * @param value Gets or sets the key vault URI to secret with the database password.
     */
    @JvmName("rssjotjyvyujworv")
    public suspend fun dbPasswordUri(`value`: Output<String>) {
        this.dbPasswordUri = value
    }

    /**
     * @param value Gets or sets the database user name.
     */
    @JvmName("bficncgjdodiethu")
    public suspend fun dbUsername(`value`: Output<String>) {
        this.dbUsername = value
    }

    /**
     * @param value Gets or sets the target virtual machine size.
     */
    @JvmName("vjmfhpedvdglbltn")
    public suspend fun hostname(`value`: Output<String>) {
        this.hostname = value
    }

    /**
     * @param value Gets or sets the database instance number.
     */
    @JvmName("lexwywbgtdyebpyd")
    public suspend fun instanceNumber(`value`: Output<String>) {
        this.instanceNumber = value
    }

    /**
     * @param value The provider type. For example, the value can be SapHana.
     * Expected value is 'SapHana'.
     */
    @JvmName("fivlytikwyomdcnh")
    public suspend fun providerType(`value`: Output<String>) {
        this.providerType = value
    }

    /**
     * @param value Gets or sets the SAP System Identifier.
     */
    @JvmName("mnnywsvvghlxegyv")
    public suspend fun sapSid(`value`: Output<String>) {
        this.sapSid = value
    }

    /**
     * @param value Gets or sets the database sql port.
     */
    @JvmName("jxndeqfkltfxxnwl")
    public suspend fun sqlPort(`value`: Output<String>) {
        this.sqlPort = value
    }

    /**
     * @param value Gets or sets the blob URI to SSL certificate for the DB.
     */
    @JvmName("oymyynjffrdysiuo")
    public suspend fun sslCertificateUri(`value`: Output<String>) {
        this.sslCertificateUri = value
    }

    /**
     * @param value Gets or sets the hostname(s) in the SSL certificate.
     */
    @JvmName("nvtvfxfvndmshvgw")
    public suspend fun sslHostNameInCertificate(`value`: Output<String>) {
        this.sslHostNameInCertificate = value
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("irysbcqjqoqgiepd")
    public suspend fun sslPreference(`value`: Output<Either<String, SslPreference>>) {
        this.sslPreference = value
    }

    /**
     * @param value Gets or sets the hana database name.
     */
    @JvmName("bgpgbrsgggkwevba")
    public suspend fun dbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbName = mapped
    }

    /**
     * @param value Gets or sets the database password.
     */
    @JvmName("msawhgkcaefhaxag")
    public suspend fun dbPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbPassword = mapped
    }

    /**
     * @param value Gets or sets the key vault URI to secret with the database password.
     */
    @JvmName("erlahsgpvdorhcaq")
    public suspend fun dbPasswordUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbPasswordUri = mapped
    }

    /**
     * @param value Gets or sets the database user name.
     */
    @JvmName("imwppqqbkdunumxb")
    public suspend fun dbUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbUsername = mapped
    }

    /**
     * @param value Gets or sets the target virtual machine size.
     */
    @JvmName("entlaglvrcndpdto")
    public suspend fun hostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param value Gets or sets the database instance number.
     */
    @JvmName("idshnxsibhxvhjgn")
    public suspend fun instanceNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceNumber = mapped
    }

    /**
     * @param value The provider type. For example, the value can be SapHana.
     * Expected value is 'SapHana'.
     */
    @JvmName("myawdhigcgitrxvw")
    public suspend fun providerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value Gets or sets the SAP System Identifier.
     */
    @JvmName("lnhtwsjvhgslidat")
    public suspend fun sapSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapSid = mapped
    }

    /**
     * @param value Gets or sets the database sql port.
     */
    @JvmName("vegouwmwtechfpga")
    public suspend fun sqlPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlPort = mapped
    }

    /**
     * @param value Gets or sets the blob URI to SSL certificate for the DB.
     */
    @JvmName("brkaljplfnujtosj")
    public suspend fun sslCertificateUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCertificateUri = mapped
    }

    /**
     * @param value Gets or sets the hostname(s) in the SSL certificate.
     */
    @JvmName("vscnpodnemyfmiev")
    public suspend fun sslHostNameInCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslHostNameInCertificate = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("gtkhwmyatpspipth")
    public suspend fun sslPreference(`value`: Either<String, SslPreference>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("fpharjhggysuirum")
    public fun sslPreference(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SslPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("ifhxekkpigbhpdde")
    public fun sslPreference(`value`: SslPreference) {
        val toBeMapped = Either.ofRight<String, SslPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    internal fun build(): HanaDbProviderInstancePropertiesArgs = HanaDbProviderInstancePropertiesArgs(
        dbName = dbName,
        dbPassword = dbPassword,
        dbPasswordUri = dbPasswordUri,
        dbUsername = dbUsername,
        hostname = hostname,
        instanceNumber = instanceNumber,
        providerType = providerType ?: throw PulumiNullFieldException("providerType"),
        sapSid = sapSid,
        sqlPort = sqlPort,
        sslCertificateUri = sslCertificateUri,
        sslHostNameInCertificate = sslHostNameInCertificate,
        sslPreference = sslPreference,
    )
}
