@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.LinuxConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
 * @property disablePasswordAuthentication Specifies whether password authentication should be disabled.
 * @property osType The OS Type
 * Expected value is 'Linux'.
 * @property ssh Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
 * @property sshKeyPair The SSH Key-pair used to authenticate with the VM's.
 */
public data class LinuxConfigurationArgs(
    public val disablePasswordAuthentication: Output<Boolean>? = null,
    public val osType: Output<String>,
    public val ssh: Output<SshConfigurationArgs>? = null,
    public val sshKeyPair: Output<SshKeyPairArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.LinuxConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.LinuxConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.LinuxConfigurationArgs.builder()
            .disablePasswordAuthentication(disablePasswordAuthentication?.applyValue({ args0 -> args0 }))
            .osType(osType.applyValue({ args0 -> args0 }))
            .ssh(ssh?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sshKeyPair(sshKeyPair?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LinuxConfigurationArgs].
 */
@PulumiTagMarker
public class LinuxConfigurationArgsBuilder internal constructor() {
    private var disablePasswordAuthentication: Output<Boolean>? = null

    private var osType: Output<String>? = null

    private var ssh: Output<SshConfigurationArgs>? = null

    private var sshKeyPair: Output<SshKeyPairArgs>? = null

    /**
     * @param value Specifies whether password authentication should be disabled.
     */
    @JvmName("igmdahmokhdmbaqh")
    public suspend fun disablePasswordAuthentication(`value`: Output<Boolean>) {
        this.disablePasswordAuthentication = value
    }

    /**
     * @param value The OS Type
     * Expected value is 'Linux'.
     */
    @JvmName("pogorfoeyrprvbnb")
    public suspend fun osType(`value`: Output<String>) {
        this.osType = value
    }

    /**
     * @param value Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
     */
    @JvmName("esmgahkkbgoueadh")
    public suspend fun ssh(`value`: Output<SshConfigurationArgs>) {
        this.ssh = value
    }

    /**
     * @param value The SSH Key-pair used to authenticate with the VM's.
     */
    @JvmName("fadijjdkwgvppemh")
    public suspend fun sshKeyPair(`value`: Output<SshKeyPairArgs>) {
        this.sshKeyPair = value
    }

    /**
     * @param value Specifies whether password authentication should be disabled.
     */
    @JvmName("qelusdnxuquuchqp")
    public suspend fun disablePasswordAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disablePasswordAuthentication = mapped
    }

    /**
     * @param value The OS Type
     * Expected value is 'Linux'.
     */
    @JvmName("kxvdgduduieuouba")
    public suspend fun osType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
     */
    @JvmName("eldxwdomlugthdik")
    public suspend fun ssh(`value`: SshConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssh = mapped
    }

    /**
     * @param argument Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
     */
    @JvmName("fvcnhxdlvpxpexuj")
    public suspend fun ssh(argument: suspend SshConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = SshConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ssh = mapped
    }

    /**
     * @param value The SSH Key-pair used to authenticate with the VM's.
     */
    @JvmName("xenbvitjefobalqy")
    public suspend fun sshKeyPair(`value`: SshKeyPairArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshKeyPair = mapped
    }

    /**
     * @param argument The SSH Key-pair used to authenticate with the VM's.
     */
    @JvmName("pmemqxtgwlbeoefa")
    public suspend fun sshKeyPair(argument: suspend SshKeyPairArgsBuilder.() -> Unit) {
        val toBeMapped = SshKeyPairArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sshKeyPair = mapped
    }

    internal fun build(): LinuxConfigurationArgs = LinuxConfigurationArgs(
        disablePasswordAuthentication = disablePasswordAuthentication,
        osType = osType ?: throw PulumiNullFieldException("osType"),
        ssh = ssh,
        sshKeyPair = sshKeyPair,
    )
}
