@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.LoadBalancerResourceNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The resource names object for load balancer and related resources.
 * @property backendPoolNames The list of backend pool names. Currently, ACSS deploys only one backend pool and hence, size of this list should be 1
 * @property frontendIpConfigurationNames The list of frontend IP configuration names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
 * @property healthProbeNames The list of health probe names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
 * @property loadBalancerName The full resource name for load balancer. If this value is not provided, load balancer will be name as {ASCS/DB}-loadBalancer.
 */
public data class LoadBalancerResourceNamesArgs(
    public val backendPoolNames: Output<List<String>>? = null,
    public val frontendIpConfigurationNames: Output<List<String>>? = null,
    public val healthProbeNames: Output<List<String>>? = null,
    public val loadBalancerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.LoadBalancerResourceNamesArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.LoadBalancerResourceNamesArgs =
        com.pulumi.azurenative.workloads.inputs.LoadBalancerResourceNamesArgs.builder()
            .backendPoolNames(backendPoolNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .frontendIpConfigurationNames(
                frontendIpConfigurationNames?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .healthProbeNames(healthProbeNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerResourceNamesArgs].
 */
@PulumiTagMarker
public class LoadBalancerResourceNamesArgsBuilder internal constructor() {
    private var backendPoolNames: Output<List<String>>? = null

    private var frontendIpConfigurationNames: Output<List<String>>? = null

    private var healthProbeNames: Output<List<String>>? = null

    private var loadBalancerName: Output<String>? = null

    /**
     * @param value The list of backend pool names. Currently, ACSS deploys only one backend pool and hence, size of this list should be 1
     */
    @JvmName("gnmgyihccvxapojd")
    public suspend fun backendPoolNames(`value`: Output<List<String>>) {
        this.backendPoolNames = value
    }

    @JvmName("ctjpouxpjygkaxsw")
    public suspend fun backendPoolNames(vararg values: Output<String>) {
        this.backendPoolNames = Output.all(values.asList())
    }

    /**
     * @param values The list of backend pool names. Currently, ACSS deploys only one backend pool and hence, size of this list should be 1
     */
    @JvmName("knggewhxpmcxitxg")
    public suspend fun backendPoolNames(values: List<Output<String>>) {
        this.backendPoolNames = Output.all(values)
    }

    /**
     * @param value The list of frontend IP configuration names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
     */
    @JvmName("jrhpwcrhfuyrqsir")
    public suspend fun frontendIpConfigurationNames(`value`: Output<List<String>>) {
        this.frontendIpConfigurationNames = value
    }

    @JvmName("rmschopuvpwqktve")
    public suspend fun frontendIpConfigurationNames(vararg values: Output<String>) {
        this.frontendIpConfigurationNames = Output.all(values.asList())
    }

    /**
     * @param values The list of frontend IP configuration names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
     */
    @JvmName("drrvcsidiogrqcpw")
    public suspend fun frontendIpConfigurationNames(values: List<Output<String>>) {
        this.frontendIpConfigurationNames = Output.all(values)
    }

    /**
     * @param value The list of health probe names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
     */
    @JvmName("gwxdykmtxqmfifgi")
    public suspend fun healthProbeNames(`value`: Output<List<String>>) {
        this.healthProbeNames = value
    }

    @JvmName("cuywtdtmlomsdqir")
    public suspend fun healthProbeNames(vararg values: Output<String>) {
        this.healthProbeNames = Output.all(values.asList())
    }

    /**
     * @param values The list of health probe names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
     */
    @JvmName("takibdnjqqdcmlrq")
    public suspend fun healthProbeNames(values: List<Output<String>>) {
        this.healthProbeNames = Output.all(values)
    }

    /**
     * @param value The full resource name for load balancer. If this value is not provided, load balancer will be name as {ASCS/DB}-loadBalancer.
     */
    @JvmName("udoxmhnqidunjmcc")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value The list of backend pool names. Currently, ACSS deploys only one backend pool and hence, size of this list should be 1
     */
    @JvmName("gucxoheivrnfiecf")
    public suspend fun backendPoolNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendPoolNames = mapped
    }

    /**
     * @param values The list of backend pool names. Currently, ACSS deploys only one backend pool and hence, size of this list should be 1
     */
    @JvmName("lvsshcrdgrestcsf")
    public suspend fun backendPoolNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendPoolNames = mapped
    }

    /**
     * @param value The list of frontend IP configuration names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
     */
    @JvmName("vkogxgyvnynbvuhj")
    public suspend fun frontendIpConfigurationNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendIpConfigurationNames = mapped
    }

    /**
     * @param values The list of frontend IP configuration names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
     */
    @JvmName("kqqwiujthnrvfsth")
    public suspend fun frontendIpConfigurationNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendIpConfigurationNames = mapped
    }

    /**
     * @param value The list of health probe names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
     */
    @JvmName("tqofbvbalbvcscxi")
    public suspend fun healthProbeNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthProbeNames = mapped
    }

    /**
     * @param values The list of health probe names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
     */
    @JvmName("jtpkpucwnkglosfv")
    public suspend fun healthProbeNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthProbeNames = mapped
    }

    /**
     * @param value The full resource name for load balancer. If this value is not provided, load balancer will be name as {ASCS/DB}-loadBalancer.
     */
    @JvmName("xhbskkyyujlucckl")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    internal fun build(): LoadBalancerResourceNamesArgs = LoadBalancerResourceNamesArgs(
        backendPoolNames = backendPoolNames,
        frontendIpConfigurationNames = frontendIpConfigurationNames,
        healthProbeNames = healthProbeNames,
        loadBalancerName = loadBalancerName,
    )
}
