@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.MountFileShareConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets or sets the file share configuration where the transport directory fileshare already exists, and user wishes to mount the fileshare as a part of the create infra flow.
 * @property configurationType The type of file share config.
 * Expected value is 'Mount'.
 * @property id The fileshare resource ID
 * @property privateEndpointId The private endpoint resource ID
 */
public data class MountFileShareConfigurationArgs(
    public val configurationType: Output<String>,
    public val id: Output<String>,
    public val privateEndpointId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.MountFileShareConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.MountFileShareConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.MountFileShareConfigurationArgs.builder()
            .configurationType(configurationType.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 }))
            .privateEndpointId(privateEndpointId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MountFileShareConfigurationArgs].
 */
@PulumiTagMarker
public class MountFileShareConfigurationArgsBuilder internal constructor() {
    private var configurationType: Output<String>? = null

    private var id: Output<String>? = null

    private var privateEndpointId: Output<String>? = null

    /**
     * @param value The type of file share config.
     * Expected value is 'Mount'.
     */
    @JvmName("bcqnvwqwrqisoaro")
    public suspend fun configurationType(`value`: Output<String>) {
        this.configurationType = value
    }

    /**
     * @param value The fileshare resource ID
     */
    @JvmName("lwvxpgtosulludyr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The private endpoint resource ID
     */
    @JvmName("mmbwslhaaattnlnb")
    public suspend fun privateEndpointId(`value`: Output<String>) {
        this.privateEndpointId = value
    }

    /**
     * @param value The type of file share config.
     * Expected value is 'Mount'.
     */
    @JvmName("tpitunkdwplopxyu")
    public suspend fun configurationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value The fileshare resource ID
     */
    @JvmName("oqvrnngpshspgigo")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The private endpoint resource ID
     */
    @JvmName("waykmjgjyvjuwblh")
    public suspend fun privateEndpointId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointId = mapped
    }

    internal fun build(): MountFileShareConfigurationArgs = MountFileShareConfigurationArgs(
        configurationType = configurationType ?: throw PulumiNullFieldException("configurationType"),
        id = id ?: throw PulumiNullFieldException("id"),
        privateEndpointId = privateEndpointId ?: throw PulumiNullFieldException("privateEndpointId"),
    )
}
