@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.MsSqlServerProviderInstancePropertiesArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SslPreference
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets or sets the SQL server provider properties.
 * @property dbPassword Gets or sets the database password.
 * @property dbPasswordUri Gets or sets the key vault URI to secret with the database password.
 * @property dbPort Gets or sets the database sql port.
 * @property dbUsername Gets or sets the database user name.
 * @property hostname Gets or sets the SQL server host name.
 * @property providerType The provider type. For example, the value can be SapHana.
 * Expected value is 'MsSqlServer'.
 * @property sapSid Gets or sets the SAP System Identifier
 * @property sslCertificateUri Gets or sets the blob URI to SSL certificate for the SQL Database.
 * @property sslPreference Gets or sets certificate preference if secure communication is enabled.
 */
public data class MsSqlServerProviderInstancePropertiesArgs(
    public val dbPassword: Output<String>? = null,
    public val dbPasswordUri: Output<String>? = null,
    public val dbPort: Output<String>? = null,
    public val dbUsername: Output<String>? = null,
    public val hostname: Output<String>? = null,
    public val providerType: Output<String>,
    public val sapSid: Output<String>? = null,
    public val sslCertificateUri: Output<String>? = null,
    public val sslPreference: Output<Either<String, SslPreference>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.MsSqlServerProviderInstancePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.MsSqlServerProviderInstancePropertiesArgs =
        com.pulumi.azurenative.workloads.inputs.MsSqlServerProviderInstancePropertiesArgs.builder()
            .dbPassword(dbPassword?.applyValue({ args0 -> args0 }))
            .dbPasswordUri(dbPasswordUri?.applyValue({ args0 -> args0 }))
            .dbPort(dbPort?.applyValue({ args0 -> args0 }))
            .dbUsername(dbUsername?.applyValue({ args0 -> args0 }))
            .hostname(hostname?.applyValue({ args0 -> args0 }))
            .providerType(providerType.applyValue({ args0 -> args0 }))
            .sapSid(sapSid?.applyValue({ args0 -> args0 }))
            .sslCertificateUri(sslCertificateUri?.applyValue({ args0 -> args0 }))
            .sslPreference(
                sslPreference?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [MsSqlServerProviderInstancePropertiesArgs].
 */
@PulumiTagMarker
public class MsSqlServerProviderInstancePropertiesArgsBuilder internal constructor() {
    private var dbPassword: Output<String>? = null

    private var dbPasswordUri: Output<String>? = null

    private var dbPort: Output<String>? = null

    private var dbUsername: Output<String>? = null

    private var hostname: Output<String>? = null

    private var providerType: Output<String>? = null

    private var sapSid: Output<String>? = null

    private var sslCertificateUri: Output<String>? = null

    private var sslPreference: Output<Either<String, SslPreference>>? = null

    /**
     * @param value Gets or sets the database password.
     */
    @JvmName("klblqcsdqmawbadq")
    public suspend fun dbPassword(`value`: Output<String>) {
        this.dbPassword = value
    }

    /**
     * @param value Gets or sets the key vault URI to secret with the database password.
     */
    @JvmName("knqxdyjqsiiclfol")
    public suspend fun dbPasswordUri(`value`: Output<String>) {
        this.dbPasswordUri = value
    }

    /**
     * @param value Gets or sets the database sql port.
     */
    @JvmName("qvoupumtsycuphux")
    public suspend fun dbPort(`value`: Output<String>) {
        this.dbPort = value
    }

    /**
     * @param value Gets or sets the database user name.
     */
    @JvmName("xsjtdivkfrvdhufy")
    public suspend fun dbUsername(`value`: Output<String>) {
        this.dbUsername = value
    }

    /**
     * @param value Gets or sets the SQL server host name.
     */
    @JvmName("sxapjxmylbbnmega")
    public suspend fun hostname(`value`: Output<String>) {
        this.hostname = value
    }

    /**
     * @param value The provider type. For example, the value can be SapHana.
     * Expected value is 'MsSqlServer'.
     */
    @JvmName("ahpjlncsbjkwuwxy")
    public suspend fun providerType(`value`: Output<String>) {
        this.providerType = value
    }

    /**
     * @param value Gets or sets the SAP System Identifier
     */
    @JvmName("iyoatofhhtfqlnaj")
    public suspend fun sapSid(`value`: Output<String>) {
        this.sapSid = value
    }

    /**
     * @param value Gets or sets the blob URI to SSL certificate for the SQL Database.
     */
    @JvmName("xhomeailqhtuhilg")
    public suspend fun sslCertificateUri(`value`: Output<String>) {
        this.sslCertificateUri = value
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("viqymigraqartwwp")
    public suspend fun sslPreference(`value`: Output<Either<String, SslPreference>>) {
        this.sslPreference = value
    }

    /**
     * @param value Gets or sets the database password.
     */
    @JvmName("thmetxtsnsgcdrvu")
    public suspend fun dbPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbPassword = mapped
    }

    /**
     * @param value Gets or sets the key vault URI to secret with the database password.
     */
    @JvmName("odhxxhnifxbcsrpm")
    public suspend fun dbPasswordUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbPasswordUri = mapped
    }

    /**
     * @param value Gets or sets the database sql port.
     */
    @JvmName("dmikgtbitqtohpry")
    public suspend fun dbPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbPort = mapped
    }

    /**
     * @param value Gets or sets the database user name.
     */
    @JvmName("qqoppiatxyqskkfe")
    public suspend fun dbUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbUsername = mapped
    }

    /**
     * @param value Gets or sets the SQL server host name.
     */
    @JvmName("rmfvvjwpgmwdidqy")
    public suspend fun hostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param value The provider type. For example, the value can be SapHana.
     * Expected value is 'MsSqlServer'.
     */
    @JvmName("ssyrdjgekdnfohcb")
    public suspend fun providerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value Gets or sets the SAP System Identifier
     */
    @JvmName("eyndvhhqesseepsj")
    public suspend fun sapSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapSid = mapped
    }

    /**
     * @param value Gets or sets the blob URI to SSL certificate for the SQL Database.
     */
    @JvmName("nbhrlduqbmimmoet")
    public suspend fun sslCertificateUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCertificateUri = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("ugfisdyhlcdiyhdg")
    public suspend fun sslPreference(`value`: Either<String, SslPreference>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("poddptsqremfskix")
    public fun sslPreference(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SslPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("lcmwqhlhpotbdqqe")
    public fun sslPreference(`value`: SslPreference) {
        val toBeMapped = Either.ofRight<String, SslPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    internal fun build(): MsSqlServerProviderInstancePropertiesArgs =
        MsSqlServerProviderInstancePropertiesArgs(
            dbPassword = dbPassword,
            dbPasswordUri = dbPasswordUri,
            dbPort = dbPort,
            dbUsername = dbUsername,
            hostname = hostname,
            providerType = providerType ?: throw PulumiNullFieldException("providerType"),
            sapSid = sapSid,
            sslCertificateUri = sslCertificateUri,
            sslPreference = sslPreference,
        )
}
