@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.OSProfileArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once VM is provisioned.
 * @property adminPassword Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs&#46;microsoft&#46;com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
 * @property adminUsername Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
 * @property osConfiguration Specifies Windows operating system settings on the virtual machine.
 */
public data class OSProfileArgs(
    public val adminPassword: Output<String>? = null,
    public val adminUsername: Output<String>? = null,
    public val osConfiguration: Output<Either<LinuxConfigurationArgs, WindowsConfigurationArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.OSProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.OSProfileArgs =
        com.pulumi.azurenative.workloads.inputs.OSProfileArgs.builder()
            .adminPassword(adminPassword?.applyValue({ args0 -> args0 }))
            .adminUsername(adminUsername?.applyValue({ args0 -> args0 }))
            .osConfiguration(
                osConfiguration?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [OSProfileArgs].
 */
@PulumiTagMarker
public class OSProfileArgsBuilder internal constructor() {
    private var adminPassword: Output<String>? = null

    private var adminUsername: Output<String>? = null

    private var osConfiguration: Output<Either<LinuxConfigurationArgs, WindowsConfigurationArgs>>? =
        null

    /**
     * @param value Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs&#46;microsoft&#46;com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
     */
    @JvmName("kxdfltitpywgxpgh")
    public suspend fun adminPassword(`value`: Output<String>) {
        this.adminPassword = value
    }

    /**
     * @param value Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
     */
    @JvmName("pimlspjfqqvawigc")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value Specifies Windows operating system settings on the virtual machine.
     */
    @JvmName("gxjbbkadwixfdaux")
    public suspend
    fun osConfiguration(`value`: Output<Either<LinuxConfigurationArgs, WindowsConfigurationArgs>>) {
        this.osConfiguration = value
    }

    /**
     * @param value Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs&#46;microsoft&#46;com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
     */
    @JvmName("ttilxdashywekdto")
    public suspend fun adminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPassword = mapped
    }

    /**
     * @param value Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
     */
    @JvmName("kbwxwbivnaybfltc")
    public suspend fun adminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value Specifies Windows operating system settings on the virtual machine.
     */
    @JvmName("iicotmitxkiueamb")
    public suspend
    fun osConfiguration(`value`: Either<LinuxConfigurationArgs, WindowsConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osConfiguration = mapped
    }

    /**
     * @param value Specifies Windows operating system settings on the virtual machine.
     */
    @JvmName("bumwulsjdooooifx")
    public fun osConfiguration(`value`: LinuxConfigurationArgs) {
        val toBeMapped = Either.ofLeft<LinuxConfigurationArgs, WindowsConfigurationArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osConfiguration = mapped
    }

    /**
     * @param value Specifies Windows operating system settings on the virtual machine.
     */
    @JvmName("syurncxddftgkqfw")
    public fun osConfiguration(`value`: WindowsConfigurationArgs) {
        val toBeMapped = Either.ofRight<LinuxConfigurationArgs, WindowsConfigurationArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osConfiguration = mapped
    }

    internal fun build(): OSProfileArgs = OSProfileArgs(
        adminPassword = adminPassword,
        adminUsername = adminUsername,
        osConfiguration = osConfiguration,
    )
}
