@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.PrometheusHaClusterProviderInstancePropertiesArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SslPreference
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets or sets the PrometheusHaCluster provider properties.
 * @property clusterName Gets or sets the clusterName.
 * @property hostname Gets or sets the target machine name.
 * @property prometheusUrl URL of the Node Exporter endpoint.
 * @property providerType The provider type. For example, the value can be SapHana.
 * Expected value is 'PrometheusHaCluster'.
 * @property sid Gets or sets the cluster sid.
 * @property sslCertificateUri Gets or sets the blob URI to SSL certificate for the HA cluster exporter.
 * @property sslPreference Gets or sets certificate preference if secure communication is enabled.
 */
public data class PrometheusHaClusterProviderInstancePropertiesArgs(
    public val clusterName: Output<String>? = null,
    public val hostname: Output<String>? = null,
    public val prometheusUrl: Output<String>? = null,
    public val providerType: Output<String>,
    public val sid: Output<String>? = null,
    public val sslCertificateUri: Output<String>? = null,
    public val sslPreference: Output<Either<String, SslPreference>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.PrometheusHaClusterProviderInstancePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.PrometheusHaClusterProviderInstancePropertiesArgs =
        com.pulumi.azurenative.workloads.inputs.PrometheusHaClusterProviderInstancePropertiesArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .hostname(hostname?.applyValue({ args0 -> args0 }))
            .prometheusUrl(prometheusUrl?.applyValue({ args0 -> args0 }))
            .providerType(providerType.applyValue({ args0 -> args0 }))
            .sid(sid?.applyValue({ args0 -> args0 }))
            .sslCertificateUri(sslCertificateUri?.applyValue({ args0 -> args0 }))
            .sslPreference(
                sslPreference?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PrometheusHaClusterProviderInstancePropertiesArgs].
 */
@PulumiTagMarker
public class PrometheusHaClusterProviderInstancePropertiesArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var hostname: Output<String>? = null

    private var prometheusUrl: Output<String>? = null

    private var providerType: Output<String>? = null

    private var sid: Output<String>? = null

    private var sslCertificateUri: Output<String>? = null

    private var sslPreference: Output<Either<String, SslPreference>>? = null

    /**
     * @param value Gets or sets the clusterName.
     */
    @JvmName("ftgdxcuoswymjwsd")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Gets or sets the target machine name.
     */
    @JvmName("ndjpsadvpgfwfdre")
    public suspend fun hostname(`value`: Output<String>) {
        this.hostname = value
    }

    /**
     * @param value URL of the Node Exporter endpoint.
     */
    @JvmName("hhuprofsrocanwum")
    public suspend fun prometheusUrl(`value`: Output<String>) {
        this.prometheusUrl = value
    }

    /**
     * @param value The provider type. For example, the value can be SapHana.
     * Expected value is 'PrometheusHaCluster'.
     */
    @JvmName("fneixppyqfqvmndm")
    public suspend fun providerType(`value`: Output<String>) {
        this.providerType = value
    }

    /**
     * @param value Gets or sets the cluster sid.
     */
    @JvmName("slhuvomekishumko")
    public suspend fun sid(`value`: Output<String>) {
        this.sid = value
    }

    /**
     * @param value Gets or sets the blob URI to SSL certificate for the HA cluster exporter.
     */
    @JvmName("jdeqdsctgpdehxtq")
    public suspend fun sslCertificateUri(`value`: Output<String>) {
        this.sslCertificateUri = value
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("nkoghsnxxbxsxfij")
    public suspend fun sslPreference(`value`: Output<Either<String, SslPreference>>) {
        this.sslPreference = value
    }

    /**
     * @param value Gets or sets the clusterName.
     */
    @JvmName("ijpcjsaecmjlvypq")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Gets or sets the target machine name.
     */
    @JvmName("scspfxhdduahcdmg")
    public suspend fun hostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param value URL of the Node Exporter endpoint.
     */
    @JvmName("wvbxfcwkrorupexl")
    public suspend fun prometheusUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prometheusUrl = mapped
    }

    /**
     * @param value The provider type. For example, the value can be SapHana.
     * Expected value is 'PrometheusHaCluster'.
     */
    @JvmName("jhkutklbcauraioc")
    public suspend fun providerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value Gets or sets the cluster sid.
     */
    @JvmName("vhcsfaprxuiusnfr")
    public suspend fun sid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sid = mapped
    }

    /**
     * @param value Gets or sets the blob URI to SSL certificate for the HA cluster exporter.
     */
    @JvmName("sctsafuvvoxuohbc")
    public suspend fun sslCertificateUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCertificateUri = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("vrjtogosigaiiwtb")
    public suspend fun sslPreference(`value`: Either<String, SslPreference>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("inugxysxcncvqxsk")
    public fun sslPreference(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SslPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("kqpuchuumutbgfyi")
    public fun sslPreference(`value`: SslPreference) {
        val toBeMapped = Either.ofRight<String, SslPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    internal fun build(): PrometheusHaClusterProviderInstancePropertiesArgs =
        PrometheusHaClusterProviderInstancePropertiesArgs(
            clusterName = clusterName,
            hostname = hostname,
            prometheusUrl = prometheusUrl,
            providerType = providerType ?: throw PulumiNullFieldException("providerType"),
            sid = sid,
            sslCertificateUri = sslCertificateUri,
            sslPreference = sslPreference,
        )
}
