@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorSidMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Gets or sets the mapping for SID to Environment/Applications.
 * @property name Gets or sets the name of the grouping.
 * @property topSid Gets or sets the list of SID's.
 */
public data class SapLandscapeMonitorSidMappingArgs(
    public val name: Output<String>? = null,
    public val topSid: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorSidMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorSidMappingArgs =
        com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorSidMappingArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .topSid(topSid?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SapLandscapeMonitorSidMappingArgs].
 */
@PulumiTagMarker
public class SapLandscapeMonitorSidMappingArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var topSid: Output<List<String>>? = null

    /**
     * @param value Gets or sets the name of the grouping.
     */
    @JvmName("twwmomfcgwamgnbf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the list of SID's.
     */
    @JvmName("yqscbmgscodglkdi")
    public suspend fun topSid(`value`: Output<List<String>>) {
        this.topSid = value
    }

    @JvmName("gnsmiwjigmdnbmoe")
    public suspend fun topSid(vararg values: Output<String>) {
        this.topSid = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of SID's.
     */
    @JvmName("cninoyfhxjaxqthy")
    public suspend fun topSid(values: List<Output<String>>) {
        this.topSid = Output.all(values)
    }

    /**
     * @param value Gets or sets the name of the grouping.
     */
    @JvmName("wirsvbfhbsnyxmqr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the list of SID's.
     */
    @JvmName("lesdatqxknjyhecg")
    public suspend fun topSid(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topSid = mapped
    }

    /**
     * @param values Gets or sets the list of SID's.
     */
    @JvmName("cnnbqxqqmrifkyka")
    public suspend fun topSid(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topSid = mapped
    }

    internal fun build(): SapLandscapeMonitorSidMappingArgs = SapLandscapeMonitorSidMappingArgs(
        name = name,
        topSid = topSid,
    )
}
