@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SapNetWeaverProviderInstancePropertiesArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SslPreference
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Gets or sets the provider properties.
 * @property providerType The provider type. For example, the value can be SapHana.
 * Expected value is 'SapNetWeaver'.
 * @property sapClientId Gets or sets the SAP Client ID.
 * @property sapHostFileEntries Gets or sets the list of HostFile Entries
 * @property sapHostname Gets or sets the target virtual machine IP Address/FQDN.
 * @property sapInstanceNr Gets or sets the instance number of SAP NetWeaver.
 * @property sapPassword Sets the SAP password.
 * @property sapPasswordUri Gets or sets the key vault URI to secret with the SAP password.
 * @property sapPortNumber Gets or sets the SAP HTTP port number.
 * @property sapSid Gets or sets the SAP System Identifier
 * @property sapUsername Gets or sets the SAP user name.
 * @property sslCertificateUri Gets or sets the blob URI to SSL certificate for the SAP system.
 * @property sslPreference Gets or sets certificate preference if secure communication is enabled.
 */
public data class SapNetWeaverProviderInstancePropertiesArgs(
    public val providerType: Output<String>,
    public val sapClientId: Output<String>? = null,
    public val sapHostFileEntries: Output<List<String>>? = null,
    public val sapHostname: Output<String>? = null,
    public val sapInstanceNr: Output<String>? = null,
    public val sapPassword: Output<String>? = null,
    public val sapPasswordUri: Output<String>? = null,
    public val sapPortNumber: Output<String>? = null,
    public val sapSid: Output<String>? = null,
    public val sapUsername: Output<String>? = null,
    public val sslCertificateUri: Output<String>? = null,
    public val sslPreference: Output<Either<String, SslPreference>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SapNetWeaverProviderInstancePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.SapNetWeaverProviderInstancePropertiesArgs =
        com.pulumi.azurenative.workloads.inputs.SapNetWeaverProviderInstancePropertiesArgs.builder()
            .providerType(providerType.applyValue({ args0 -> args0 }))
            .sapClientId(sapClientId?.applyValue({ args0 -> args0 }))
            .sapHostFileEntries(sapHostFileEntries?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sapHostname(sapHostname?.applyValue({ args0 -> args0 }))
            .sapInstanceNr(sapInstanceNr?.applyValue({ args0 -> args0 }))
            .sapPassword(sapPassword?.applyValue({ args0 -> args0 }))
            .sapPasswordUri(sapPasswordUri?.applyValue({ args0 -> args0 }))
            .sapPortNumber(sapPortNumber?.applyValue({ args0 -> args0 }))
            .sapSid(sapSid?.applyValue({ args0 -> args0 }))
            .sapUsername(sapUsername?.applyValue({ args0 -> args0 }))
            .sslCertificateUri(sslCertificateUri?.applyValue({ args0 -> args0 }))
            .sslPreference(
                sslPreference?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SapNetWeaverProviderInstancePropertiesArgs].
 */
@PulumiTagMarker
public class SapNetWeaverProviderInstancePropertiesArgsBuilder internal constructor() {
    private var providerType: Output<String>? = null

    private var sapClientId: Output<String>? = null

    private var sapHostFileEntries: Output<List<String>>? = null

    private var sapHostname: Output<String>? = null

    private var sapInstanceNr: Output<String>? = null

    private var sapPassword: Output<String>? = null

    private var sapPasswordUri: Output<String>? = null

    private var sapPortNumber: Output<String>? = null

    private var sapSid: Output<String>? = null

    private var sapUsername: Output<String>? = null

    private var sslCertificateUri: Output<String>? = null

    private var sslPreference: Output<Either<String, SslPreference>>? = null

    /**
     * @param value The provider type. For example, the value can be SapHana.
     * Expected value is 'SapNetWeaver'.
     */
    @JvmName("hqunimoemyogxbew")
    public suspend fun providerType(`value`: Output<String>) {
        this.providerType = value
    }

    /**
     * @param value Gets or sets the SAP Client ID.
     */
    @JvmName("acsaotuhdepvkoqh")
    public suspend fun sapClientId(`value`: Output<String>) {
        this.sapClientId = value
    }

    /**
     * @param value Gets or sets the list of HostFile Entries
     */
    @JvmName("kfygdxgiincscdkn")
    public suspend fun sapHostFileEntries(`value`: Output<List<String>>) {
        this.sapHostFileEntries = value
    }

    @JvmName("xkbimbhamexqqgve")
    public suspend fun sapHostFileEntries(vararg values: Output<String>) {
        this.sapHostFileEntries = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of HostFile Entries
     */
    @JvmName("svklsgxmnogunidv")
    public suspend fun sapHostFileEntries(values: List<Output<String>>) {
        this.sapHostFileEntries = Output.all(values)
    }

    /**
     * @param value Gets or sets the target virtual machine IP Address/FQDN.
     */
    @JvmName("srxheucpwvltnqpa")
    public suspend fun sapHostname(`value`: Output<String>) {
        this.sapHostname = value
    }

    /**
     * @param value Gets or sets the instance number of SAP NetWeaver.
     */
    @JvmName("qkmfcnvdtwkdsgdd")
    public suspend fun sapInstanceNr(`value`: Output<String>) {
        this.sapInstanceNr = value
    }

    /**
     * @param value Sets the SAP password.
     */
    @JvmName("nulobqksgpounqyt")
    public suspend fun sapPassword(`value`: Output<String>) {
        this.sapPassword = value
    }

    /**
     * @param value Gets or sets the key vault URI to secret with the SAP password.
     */
    @JvmName("ergdhqexssqstvfv")
    public suspend fun sapPasswordUri(`value`: Output<String>) {
        this.sapPasswordUri = value
    }

    /**
     * @param value Gets or sets the SAP HTTP port number.
     */
    @JvmName("thiqisuwugmulkpj")
    public suspend fun sapPortNumber(`value`: Output<String>) {
        this.sapPortNumber = value
    }

    /**
     * @param value Gets or sets the SAP System Identifier
     */
    @JvmName("mnrfdslqbvalywak")
    public suspend fun sapSid(`value`: Output<String>) {
        this.sapSid = value
    }

    /**
     * @param value Gets or sets the SAP user name.
     */
    @JvmName("nnicycdfpqcnofxi")
    public suspend fun sapUsername(`value`: Output<String>) {
        this.sapUsername = value
    }

    /**
     * @param value Gets or sets the blob URI to SSL certificate for the SAP system.
     */
    @JvmName("qbpgdjkrcmgwdqed")
    public suspend fun sslCertificateUri(`value`: Output<String>) {
        this.sslCertificateUri = value
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("njsdfkapvucelcrc")
    public suspend fun sslPreference(`value`: Output<Either<String, SslPreference>>) {
        this.sslPreference = value
    }

    /**
     * @param value The provider type. For example, the value can be SapHana.
     * Expected value is 'SapNetWeaver'.
     */
    @JvmName("bxohqiirycvqvonx")
    public suspend fun providerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value Gets or sets the SAP Client ID.
     */
    @JvmName("alpshgrlenwfgsyw")
    public suspend fun sapClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapClientId = mapped
    }

    /**
     * @param value Gets or sets the list of HostFile Entries
     */
    @JvmName("cylsbuonxbblpgho")
    public suspend fun sapHostFileEntries(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapHostFileEntries = mapped
    }

    /**
     * @param values Gets or sets the list of HostFile Entries
     */
    @JvmName("nwgkguwevwjhslnx")
    public suspend fun sapHostFileEntries(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sapHostFileEntries = mapped
    }

    /**
     * @param value Gets or sets the target virtual machine IP Address/FQDN.
     */
    @JvmName("gamxtehpgrosfwch")
    public suspend fun sapHostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapHostname = mapped
    }

    /**
     * @param value Gets or sets the instance number of SAP NetWeaver.
     */
    @JvmName("bovufeljbenguhuw")
    public suspend fun sapInstanceNr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapInstanceNr = mapped
    }

    /**
     * @param value Sets the SAP password.
     */
    @JvmName("bnejexdbiehneeqo")
    public suspend fun sapPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapPassword = mapped
    }

    /**
     * @param value Gets or sets the key vault URI to secret with the SAP password.
     */
    @JvmName("yqmosjbmycppmmun")
    public suspend fun sapPasswordUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapPasswordUri = mapped
    }

    /**
     * @param value Gets or sets the SAP HTTP port number.
     */
    @JvmName("takckfuufviyhdyl")
    public suspend fun sapPortNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapPortNumber = mapped
    }

    /**
     * @param value Gets or sets the SAP System Identifier
     */
    @JvmName("vrmldtglmtfokgbo")
    public suspend fun sapSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapSid = mapped
    }

    /**
     * @param value Gets or sets the SAP user name.
     */
    @JvmName("cxbhnmpydlgvfkyt")
    public suspend fun sapUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapUsername = mapped
    }

    /**
     * @param value Gets or sets the blob URI to SSL certificate for the SAP system.
     */
    @JvmName("fcqgtevylnmerwfc")
    public suspend fun sslCertificateUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCertificateUri = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("sccqnrujiokhhcpg")
    public suspend fun sslPreference(`value`: Either<String, SslPreference>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("dtemcmgecsjjrdvb")
    public fun sslPreference(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SslPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("vnqyehsfeocenivm")
    public fun sslPreference(`value`: SslPreference) {
        val toBeMapped = Either.ofRight<String, SslPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    internal fun build(): SapNetWeaverProviderInstancePropertiesArgs =
        SapNetWeaverProviderInstancePropertiesArgs(
            providerType = providerType ?: throw PulumiNullFieldException("providerType"),
            sapClientId = sapClientId,
            sapHostFileEntries = sapHostFileEntries,
            sapHostname = sapHostname,
            sapInstanceNr = sapInstanceNr,
            sapPassword = sapPassword,
            sapPasswordUri = sapPasswordUri,
            sapPortNumber = sapPortNumber,
            sapSid = sapSid,
            sapUsername = sapUsername,
            sslCertificateUri = sslCertificateUri,
            sslPreference = sslPreference,
        )
}
