@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SnapshotBackupAdditionalDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Snapshot Backup related fields for WorkloadType SAP Hana system
 * @property instantRPDetails Instant RP details for the snapshot.
 * @property instantRpRetentionRangeInDays Retention range for instant Rp in days.
 * @property userAssignedManagedIdentityDetails User Assigned managed identity details used for snapshot policy.
 */
public data class SnapshotBackupAdditionalDetailsArgs(
    public val instantRPDetails: Output<String>? = null,
    public val instantRpRetentionRangeInDays: Output<Int>? = null,
    public val userAssignedManagedIdentityDetails: Output<UserAssignedManagedIdentityDetailsArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SnapshotBackupAdditionalDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SnapshotBackupAdditionalDetailsArgs =
        com.pulumi.azurenative.workloads.inputs.SnapshotBackupAdditionalDetailsArgs.builder()
            .instantRPDetails(instantRPDetails?.applyValue({ args0 -> args0 }))
            .instantRpRetentionRangeInDays(instantRpRetentionRangeInDays?.applyValue({ args0 -> args0 }))
            .userAssignedManagedIdentityDetails(
                userAssignedManagedIdentityDetails?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [SnapshotBackupAdditionalDetailsArgs].
 */
@PulumiTagMarker
public class SnapshotBackupAdditionalDetailsArgsBuilder internal constructor() {
    private var instantRPDetails: Output<String>? = null

    private var instantRpRetentionRangeInDays: Output<Int>? = null

    private var userAssignedManagedIdentityDetails: Output<UserAssignedManagedIdentityDetailsArgs>? =
        null

    /**
     * @param value Instant RP details for the snapshot.
     */
    @JvmName("ldvirjvdvfvwbgui")
    public suspend fun instantRPDetails(`value`: Output<String>) {
        this.instantRPDetails = value
    }

    /**
     * @param value Retention range for instant Rp in days.
     */
    @JvmName("nyvqvbjdyvwgtegc")
    public suspend fun instantRpRetentionRangeInDays(`value`: Output<Int>) {
        this.instantRpRetentionRangeInDays = value
    }

    /**
     * @param value User Assigned managed identity details used for snapshot policy.
     */
    @JvmName("dnfqbwmsaagkctwx")
    public suspend
    fun userAssignedManagedIdentityDetails(`value`: Output<UserAssignedManagedIdentityDetailsArgs>) {
        this.userAssignedManagedIdentityDetails = value
    }

    /**
     * @param value Instant RP details for the snapshot.
     */
    @JvmName("hucocsyxblmwudgi")
    public suspend fun instantRPDetails(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instantRPDetails = mapped
    }

    /**
     * @param value Retention range for instant Rp in days.
     */
    @JvmName("lqprdayasdvmlipy")
    public suspend fun instantRpRetentionRangeInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instantRpRetentionRangeInDays = mapped
    }

    /**
     * @param value User Assigned managed identity details used for snapshot policy.
     */
    @JvmName("rgtdujbfijtgeaac")
    public suspend
    fun userAssignedManagedIdentityDetails(`value`: UserAssignedManagedIdentityDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedManagedIdentityDetails = mapped
    }

    /**
     * @param argument User Assigned managed identity details used for snapshot policy.
     */
    @JvmName("lmcktockmitbghcy")
    public suspend
    fun userAssignedManagedIdentityDetails(argument: suspend UserAssignedManagedIdentityDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = UserAssignedManagedIdentityDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.userAssignedManagedIdentityDetails = mapped
    }

    internal fun build(): SnapshotBackupAdditionalDetailsArgs = SnapshotBackupAdditionalDetailsArgs(
        instantRPDetails = instantRPDetails,
        instantRpRetentionRangeInDays = instantRpRetentionRangeInDays,
        userAssignedManagedIdentityDetails = userAssignedManagedIdentityDetails,
    )
}
