@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SqlBackupDataArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the SQL Backup data for a virtual instance for SAP.
 * @property backupPolicy Defines the policy properties for database backup.
 * @property backupType The type of backup, VM, SQL or HANA.
 * Expected value is 'SQL'.
 * @property recoveryServicesVault The properties of the recovery services vault used for backup.
 */
public data class SqlBackupDataArgs(
    public val backupPolicy: Output<DBBackupPolicyPropertiesArgs>,
    public val backupType: Output<String>,
    public val recoveryServicesVault:
    Output<Either<ExistingRecoveryServicesVaultArgs, NewRecoveryServicesVaultArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SqlBackupDataArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SqlBackupDataArgs =
        com.pulumi.azurenative.workloads.inputs.SqlBackupDataArgs.builder()
            .backupPolicy(backupPolicy.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .backupType(backupType.applyValue({ args0 -> args0 }))
            .recoveryServicesVault(
                recoveryServicesVault.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlBackupDataArgs].
 */
@PulumiTagMarker
public class SqlBackupDataArgsBuilder internal constructor() {
    private var backupPolicy: Output<DBBackupPolicyPropertiesArgs>? = null

    private var backupType: Output<String>? = null

    private var recoveryServicesVault:
        Output<Either<ExistingRecoveryServicesVaultArgs, NewRecoveryServicesVaultArgs>>? = null

    /**
     * @param value Defines the policy properties for database backup.
     */
    @JvmName("hpxrtpbxekiknltl")
    public suspend fun backupPolicy(`value`: Output<DBBackupPolicyPropertiesArgs>) {
        this.backupPolicy = value
    }

    /**
     * @param value The type of backup, VM, SQL or HANA.
     * Expected value is 'SQL'.
     */
    @JvmName("wyqheylhrbwdjeof")
    public suspend fun backupType(`value`: Output<String>) {
        this.backupType = value
    }

    /**
     * @param value The properties of the recovery services vault used for backup.
     */
    @JvmName("lokjbisnpwtwpcul")
    public suspend
    fun recoveryServicesVault(`value`: Output<Either<ExistingRecoveryServicesVaultArgs, NewRecoveryServicesVaultArgs>>) {
        this.recoveryServicesVault = value
    }

    /**
     * @param value Defines the policy properties for database backup.
     */
    @JvmName("bjxjoqomjcpomnvj")
    public suspend fun backupPolicy(`value`: DBBackupPolicyPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupPolicy = mapped
    }

    /**
     * @param argument Defines the policy properties for database backup.
     */
    @JvmName("worgyhujbhxjcfyf")
    public suspend
    fun backupPolicy(argument: suspend DBBackupPolicyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DBBackupPolicyPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupPolicy = mapped
    }

    /**
     * @param value The type of backup, VM, SQL or HANA.
     * Expected value is 'SQL'.
     */
    @JvmName("iurbjfadmlyoboij")
    public suspend fun backupType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupType = mapped
    }

    /**
     * @param value The properties of the recovery services vault used for backup.
     */
    @JvmName("ulckbovywrimunue")
    public suspend
    fun recoveryServicesVault(`value`: Either<ExistingRecoveryServicesVaultArgs, NewRecoveryServicesVaultArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryServicesVault = mapped
    }

    /**
     * @param value The properties of the recovery services vault used for backup.
     */
    @JvmName("otactxwhunllckdx")
    public fun recoveryServicesVault(`value`: ExistingRecoveryServicesVaultArgs) {
        val toBeMapped = Either.ofLeft<ExistingRecoveryServicesVaultArgs,
            NewRecoveryServicesVaultArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryServicesVault = mapped
    }

    /**
     * @param value The properties of the recovery services vault used for backup.
     */
    @JvmName("ffipnxenrlmxxuev")
    public fun recoveryServicesVault(`value`: NewRecoveryServicesVaultArgs) {
        val toBeMapped = Either.ofRight<ExistingRecoveryServicesVaultArgs,
            NewRecoveryServicesVaultArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryServicesVault = mapped
    }

    internal fun build(): SqlBackupDataArgs = SqlBackupDataArgs(
        backupPolicy = backupPolicy ?: throw PulumiNullFieldException("backupPolicy"),
        backupType = backupType ?: throw PulumiNullFieldException("backupType"),
        recoveryServicesVault = recoveryServicesVault ?: throw
            PulumiNullFieldException("recoveryServicesVault"),
    )
}
