@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SshConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SSH configuration for Linux based VMs running on Azure
 * @property publicKeys The list of SSH public keys used to authenticate with linux based VMs.
 */
public data class SshConfigurationArgs(
    public val publicKeys: Output<List<SshPublicKeyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SshConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SshConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.SshConfigurationArgs.builder()
            .publicKeys(
                publicKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SshConfigurationArgs].
 */
@PulumiTagMarker
public class SshConfigurationArgsBuilder internal constructor() {
    private var publicKeys: Output<List<SshPublicKeyArgs>>? = null

    /**
     * @param value The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("gpnyhknnooevremx")
    public suspend fun publicKeys(`value`: Output<List<SshPublicKeyArgs>>) {
        this.publicKeys = value
    }

    @JvmName("nayxckojqckeihgx")
    public suspend fun publicKeys(vararg values: Output<SshPublicKeyArgs>) {
        this.publicKeys = Output.all(values.asList())
    }

    /**
     * @param values The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("yvihckadoefifdmm")
    public suspend fun publicKeys(values: List<Output<SshPublicKeyArgs>>) {
        this.publicKeys = Output.all(values)
    }

    /**
     * @param value The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("ifjdrdlsjsdkhaxk")
    public suspend fun publicKeys(`value`: List<SshPublicKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    /**
     * @param argument The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("iryeqqrmvjeeolnr")
    public suspend fun publicKeys(argument: List<suspend SshPublicKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SshPublicKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param argument The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("jftyjeykysviwshj")
    public suspend fun publicKeys(vararg argument: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SshPublicKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param argument The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("akrntlnhajbyuwvf")
    public suspend fun publicKeys(argument: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SshPublicKeyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param values The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("ernmufgjstwfiwaf")
    public suspend fun publicKeys(vararg values: SshPublicKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    internal fun build(): SshConfigurationArgs = SshConfigurationArgs(
        publicKeys = publicKeys,
    )
}
