@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.StorageConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets or sets the storage configuration.
 * @property transportFileShareConfiguration The properties of the transport directory attached to the VIS. The default for transportFileShareConfiguration is the createAndMount flow if storage configuration is missing.
 */
public data class StorageConfigurationArgs(
    public val transportFileShareConfiguration: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.StorageConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.StorageConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.StorageConfigurationArgs.builder()
            .transportFileShareConfiguration(
                transportFileShareConfiguration?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [StorageConfigurationArgs].
 */
@PulumiTagMarker
public class StorageConfigurationArgsBuilder internal constructor() {
    private var transportFileShareConfiguration: Output<Any>? = null

    /**
     * @param value The properties of the transport directory attached to the VIS. The default for transportFileShareConfiguration is the createAndMount flow if storage configuration is missing.
     */
    @JvmName("byvcavnrjlrsexdw")
    public suspend fun transportFileShareConfiguration(`value`: Output<Any>) {
        this.transportFileShareConfiguration = value
    }

    /**
     * @param value The properties of the transport directory attached to the VIS. The default for transportFileShareConfiguration is the createAndMount flow if storage configuration is missing.
     */
    @JvmName("tbsicskfmcnclvdw")
    public suspend fun transportFileShareConfiguration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportFileShareConfiguration = mapped
    }

    internal fun build(): StorageConfigurationArgs = StorageConfigurationArgs(
        transportFileShareConfiguration = transportFileShareConfiguration,
    )
}
