@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.UserAssignedIdentityPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User assigned managed identity properties.
 * @property clientId
 * @property principalId
 */
public data class UserAssignedIdentityPropertiesArgs(
    public val clientId: Output<String>? = null,
    public val principalId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.UserAssignedIdentityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.UserAssignedIdentityPropertiesArgs =
        com.pulumi.azurenative.workloads.inputs.UserAssignedIdentityPropertiesArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAssignedIdentityPropertiesArgs].
 */
@PulumiTagMarker
public class UserAssignedIdentityPropertiesArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var principalId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("achafweudgdcpdsq")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value
     */
    @JvmName("aukpyegtcofjkcav")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value
     */
    @JvmName("djdrwyyjskbhrukf")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value
     */
    @JvmName("fagfuxsgmjedecmg")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    internal fun build(): UserAssignedIdentityPropertiesArgs = UserAssignedIdentityPropertiesArgs(
        clientId = clientId,
        principalId = principalId,
    )
}
