@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
 * @property availabilitySetName The full name for availability set. In case name is not provided, it will be defaulted to {SID}-App-AvSet.
 * @property virtualMachines The list of virtual machine naming details.
 */
public data class ApplicationServerFullResourceNamesResponse(
    public val availabilitySetName: String? = null,
    public val virtualMachines: List<VirtualMachineResourceNamesResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.ApplicationServerFullResourceNamesResponse):
            ApplicationServerFullResourceNamesResponse = ApplicationServerFullResourceNamesResponse(
            availabilitySetName = javaType.availabilitySetName().map({ args0 -> args0 }).orElse(null),
            virtualMachines = javaType.virtualMachines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.VirtualMachineResourceNamesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
