@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the file share configuration where the transport directory fileshare is created and mounted as a part of the create infra flow. Please pre-create the resource group you intend to place the transport directory in. The storage account and fileshare will be auto-created by the ACSS and doesn’t need to pre-created.
 * @property configurationType The type of file share config.
 * Expected value is 'CreateAndMount'.
 * @property resourceGroup The name of transport file share resource group. This should be pre created by the customer. The app rg is used in case of missing input.
 * @property storageAccountName The name of file share storage account name . A custom name is used in case of missing input.
 */
public data class CreateAndMountFileShareConfigurationResponse(
    public val configurationType: String,
    public val resourceGroup: String? = null,
    public val storageAccountName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.CreateAndMountFileShareConfigurationResponse):
            CreateAndMountFileShareConfigurationResponse = CreateAndMountFileShareConfigurationResponse(
            configurationType = javaType.configurationType(),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            storageAccountName = javaType.storageAccountName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
