@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the database configuration.
 * @property databaseType The database type.
 * @property diskConfiguration Gets or sets the disk configuration.
 * @property instanceCount The number of database VMs.
 * @property subnetId The subnet id.
 * @property virtualMachineConfiguration Gets or sets the virtual machine configuration.
 */
public data class DatabaseConfigurationResponse(
    public val databaseType: String? = null,
    public val diskConfiguration: DiskConfigurationResponse? = null,
    public val instanceCount: Double,
    public val subnetId: String,
    public val virtualMachineConfiguration: VirtualMachineConfigurationResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.DatabaseConfigurationResponse):
            DatabaseConfigurationResponse = DatabaseConfigurationResponse(
            databaseType = javaType.databaseType().map({ args0 -> args0 }).orElse(null),
            diskConfiguration = javaType.diskConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.DiskConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instanceCount = javaType.instanceCount(),
            subnetId = javaType.subnetId(),
            virtualMachineConfiguration = javaType.virtualMachineConfiguration().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.VirtualMachineConfigurationResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
