@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The SAP Software configuration Input when the software is installed externally outside the service.
 * @property centralServerVmId The resource ID of the virtual machine containing the central server instance.
 * @property softwareInstallationType The SAP software installation Type.
 * Expected value is 'External'.
 */
public data class ExternalInstallationSoftwareConfigurationResponse(
    public val centralServerVmId: String? = null,
    public val softwareInstallationType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.ExternalInstallationSoftwareConfigurationResponse):
            ExternalInstallationSoftwareConfigurationResponse =
            ExternalInstallationSoftwareConfigurationResponse(
                centralServerVmId = javaType.centralServerVmId().map({ args0 -> args0 }).orElse(null),
                softwareInstallationType = javaType.softwareInstallationType(),
            )
    }
}
