@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
 * @property disablePasswordAuthentication Specifies whether password authentication should be disabled.
 * @property osType The OS Type
 * Expected value is 'Linux'.
 * @property ssh Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
 * @property sshKeyPair The SSH Key-pair used to authenticate with the VM's.
 */
public data class LinuxConfigurationResponse(
    public val disablePasswordAuthentication: Boolean? = null,
    public val osType: String,
    public val ssh: SshConfigurationResponse? = null,
    public val sshKeyPair: SshKeyPairResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.LinuxConfigurationResponse):
            LinuxConfigurationResponse = LinuxConfigurationResponse(
            disablePasswordAuthentication = javaType.disablePasswordAuthentication().map({ args0 ->
                args0
            }).orElse(null),
            osType = javaType.osType(),
            ssh = javaType.ssh().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.SshConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sshKeyPair = javaType.sshKeyPair().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.SshKeyPairResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
