@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Defines the SAP Message Server properties.
 * @property health Defines the health of SAP Instances.
 * @property hostname Message Server SAP Hostname.
 * @property httpPort Message Server HTTP Port.
 * @property httpsPort Message Server HTTPS Port.
 * @property internalMsPort Message Server internal MS port.
 * @property ipAddress Message server IP Address.
 * @property msPort Message Server port.
 */
public data class MessageServerPropertiesResponse(
    public val health: String,
    public val hostname: String,
    public val httpPort: Double,
    public val httpsPort: Double,
    public val internalMsPort: Double,
    public val ipAddress: String,
    public val msPort: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.MessageServerPropertiesResponse):
            MessageServerPropertiesResponse = MessageServerPropertiesResponse(
            health = javaType.health(),
            hostname = javaType.hostname(),
            httpPort = javaType.httpPort(),
            httpsPort = javaType.httpsPort(),
            internalMsPort = javaType.internalMsPort(),
            ipAddress = javaType.ipAddress(),
            msPort = javaType.msPort(),
        )
    }
}
