@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the Threshold Values for Top Metrics Health.
 * @property green Gets or sets the threshold value for Green.
 * @property name Gets or sets the name of the threshold.
 * @property red Gets or sets the threshold value for Red.
 * @property yellow Gets or sets the threshold value for Yellow.
 */
public data class SapLandscapeMonitorMetricThresholdsResponse(
    public val green: Double? = null,
    public val name: String? = null,
    public val red: Double? = null,
    public val yellow: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SapLandscapeMonitorMetricThresholdsResponse):
            SapLandscapeMonitorMetricThresholdsResponse = SapLandscapeMonitorMetricThresholdsResponse(
            green = javaType.green().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            red = javaType.red().map({ args0 -> args0 }).orElse(null),
            yellow = javaType.yellow().map({ args0 -> args0 }).orElse(null),
        )
    }
}
