@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the file share configuration for scenarios where transport directory fileshare is not created or required.
 * @property configurationType The type of file share config.
 * Expected value is 'Skip'.
 */
public data class SkipFileShareConfigurationResponse(
    public val configurationType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SkipFileShareConfigurationResponse):
            SkipFileShareConfigurationResponse = SkipFileShareConfigurationResponse(
            configurationType = javaType.configurationType(),
        )
    }
}
