@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The resource name object where the specified values will be full resource names of the corresponding resources in a three tier SAP system.
 * @property applicationServer The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
 * @property centralServer The full resource names object for central server layer resources.
 * @property databaseServer The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
 * @property namingPatternType The pattern type to be used for resource naming.
 * Expected value is 'FullResourceName'.
 * @property sharedStorage The resource names object for shared storage.
 */
public data class ThreeTierFullResourceNamesResponse(
    public val applicationServer: ApplicationServerFullResourceNamesResponse? = null,
    public val centralServer: CentralServerFullResourceNamesResponse? = null,
    public val databaseServer: DatabaseServerFullResourceNamesResponse? = null,
    public val namingPatternType: String,
    public val sharedStorage: SharedStorageResourceNamesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.ThreeTierFullResourceNamesResponse):
            ThreeTierFullResourceNamesResponse = ThreeTierFullResourceNamesResponse(
            applicationServer = javaType.applicationServer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.ApplicationServerFullResourceNamesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            centralServer = javaType.centralServer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.CentralServerFullResourceNamesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            databaseServer = javaType.databaseServer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.DatabaseServerFullResourceNamesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            namingPatternType = javaType.namingPatternType(),
            sharedStorage = javaType.sharedStorage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.SharedStorageResourceNamesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
