@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.inputs

import com.pulumi.azurenative.aad.inputs.ConfigDiagnosticsValidatorResultArgs.builder
import com.pulumi.azurenative.aad.kotlin.enums.Status
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Config Diagnostics validator result data
 * @property issues List of resource config validation issues.
 * @property replicaSetSubnetDisplayName Replica set location and subnet name
 * @property status Status for individual validator after running diagnostics.
 * @property validatorId Validator identifier
 */
public data class ConfigDiagnosticsValidatorResultArgs(
    public val issues: Output<List<ConfigDiagnosticsValidatorResultIssueArgs>>? = null,
    public val replicaSetSubnetDisplayName: Output<String>? = null,
    public val status: Output<Either<String, Status>>? = null,
    public val validatorId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aad.inputs.ConfigDiagnosticsValidatorResultArgs> {
    override fun toJava(): com.pulumi.azurenative.aad.inputs.ConfigDiagnosticsValidatorResultArgs =
        com.pulumi.azurenative.aad.inputs.ConfigDiagnosticsValidatorResultArgs.builder()
            .issues(issues?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .replicaSetSubnetDisplayName(replicaSetSubnetDisplayName?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .validatorId(validatorId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigDiagnosticsValidatorResultArgs].
 */
@PulumiTagMarker
public class ConfigDiagnosticsValidatorResultArgsBuilder internal constructor() {
    private var issues: Output<List<ConfigDiagnosticsValidatorResultIssueArgs>>? = null

    private var replicaSetSubnetDisplayName: Output<String>? = null

    private var status: Output<Either<String, Status>>? = null

    private var validatorId: Output<String>? = null

    /**
     * @param value List of resource config validation issues.
     */
    @JvmName("chrjywbptujmixsb")
    public suspend fun issues(`value`: Output<List<ConfigDiagnosticsValidatorResultIssueArgs>>) {
        this.issues = value
    }

    @JvmName("iechrvbkhrivpesl")
    public suspend fun issues(vararg values: Output<ConfigDiagnosticsValidatorResultIssueArgs>) {
        this.issues = Output.all(values.asList())
    }

    /**
     * @param values List of resource config validation issues.
     */
    @JvmName("ggdgeuwdjywfcuub")
    public suspend fun issues(values: List<Output<ConfigDiagnosticsValidatorResultIssueArgs>>) {
        this.issues = Output.all(values)
    }

    /**
     * @param value Replica set location and subnet name
     */
    @JvmName("svjbxfrofqxjipbp")
    public suspend fun replicaSetSubnetDisplayName(`value`: Output<String>) {
        this.replicaSetSubnetDisplayName = value
    }

    /**
     * @param value Status for individual validator after running diagnostics.
     */
    @JvmName("hgfbtbvuhinaplrs")
    public suspend fun status(`value`: Output<Either<String, Status>>) {
        this.status = value
    }

    /**
     * @param value Validator identifier
     */
    @JvmName("fefuplbyntitljof")
    public suspend fun validatorId(`value`: Output<String>) {
        this.validatorId = value
    }

    /**
     * @param value List of resource config validation issues.
     */
    @JvmName("luairbnapokpkqxc")
    public suspend fun issues(`value`: List<ConfigDiagnosticsValidatorResultIssueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issues = mapped
    }

    /**
     * @param argument List of resource config validation issues.
     */
    @JvmName("rnabiwcqnwbjxlsd")
    public suspend
    fun issues(argument: List<suspend ConfigDiagnosticsValidatorResultIssueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConfigDiagnosticsValidatorResultIssueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.issues = mapped
    }

    /**
     * @param argument List of resource config validation issues.
     */
    @JvmName("xepvokpenybduuvv")
    public suspend fun issues(
        vararg
        argument: suspend ConfigDiagnosticsValidatorResultIssueArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConfigDiagnosticsValidatorResultIssueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.issues = mapped
    }

    /**
     * @param argument List of resource config validation issues.
     */
    @JvmName("cgobcfgpklwgmnwi")
    public suspend
    fun issues(argument: suspend ConfigDiagnosticsValidatorResultIssueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConfigDiagnosticsValidatorResultIssueArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.issues = mapped
    }

    /**
     * @param values List of resource config validation issues.
     */
    @JvmName("rctiraiefircscsq")
    public suspend fun issues(vararg values: ConfigDiagnosticsValidatorResultIssueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.issues = mapped
    }

    /**
     * @param value Replica set location and subnet name
     */
    @JvmName("aopwuehumgraqtjj")
    public suspend fun replicaSetSubnetDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaSetSubnetDisplayName = mapped
    }

    /**
     * @param value Status for individual validator after running diagnostics.
     */
    @JvmName("geaooehkuxqntwrn")
    public suspend fun status(`value`: Either<String, Status>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status for individual validator after running diagnostics.
     */
    @JvmName("imfrlpexdmccnyhd")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status for individual validator after running diagnostics.
     */
    @JvmName("tetqdelxmglgccvm")
    public fun status(`value`: Status) {
        val toBeMapped = Either.ofRight<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Validator identifier
     */
    @JvmName("ldyhjbohevrxieak")
    public suspend fun validatorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validatorId = mapped
    }

    internal fun build(): ConfigDiagnosticsValidatorResultArgs = ConfigDiagnosticsValidatorResultArgs(
        issues = issues,
        replicaSetSubnetDisplayName = replicaSetSubnetDisplayName,
        status = status,
        validatorId = validatorId,
    )
}
