@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.inputs

import com.pulumi.azurenative.aad.inputs.DomainSecuritySettingsArgs.builder
import com.pulumi.azurenative.aad.kotlin.enums.ChannelBinding
import com.pulumi.azurenative.aad.kotlin.enums.KerberosArmoring
import com.pulumi.azurenative.aad.kotlin.enums.KerberosRc4Encryption
import com.pulumi.azurenative.aad.kotlin.enums.LdapSigning
import com.pulumi.azurenative.aad.kotlin.enums.NtlmV1
import com.pulumi.azurenative.aad.kotlin.enums.SyncKerberosPasswords
import com.pulumi.azurenative.aad.kotlin.enums.SyncNtlmPasswords
import com.pulumi.azurenative.aad.kotlin.enums.SyncOnPremPasswords
import com.pulumi.azurenative.aad.kotlin.enums.TlsV1
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Domain Security Settings
 * @property channelBinding A flag to determine whether or not ChannelBinding is enabled or disabled.
 * @property kerberosArmoring A flag to determine whether or not KerberosArmoring is enabled or disabled.
 * @property kerberosRc4Encryption A flag to determine whether or not KerberosRc4Encryption is enabled or disabled.
 * @property ldapSigning A flag to determine whether or not LdapSigning is enabled or disabled.
 * @property ntlmV1 A flag to determine whether or not NtlmV1 is enabled or disabled.
 * @property syncKerberosPasswords A flag to determine whether or not SyncKerberosPasswords is enabled or disabled.
 * @property syncNtlmPasswords A flag to determine whether or not SyncNtlmPasswords is enabled or disabled.
 * @property syncOnPremPasswords A flag to determine whether or not SyncOnPremPasswords is enabled or disabled.
 * @property tlsV1 A flag to determine whether or not TlsV1 is enabled or disabled.
 */
public data class DomainSecuritySettingsArgs(
    public val channelBinding: Output<Either<String, ChannelBinding>>? = null,
    public val kerberosArmoring: Output<Either<String, KerberosArmoring>>? = null,
    public val kerberosRc4Encryption: Output<Either<String, KerberosRc4Encryption>>? = null,
    public val ldapSigning: Output<Either<String, LdapSigning>>? = null,
    public val ntlmV1: Output<Either<String, NtlmV1>>? = null,
    public val syncKerberosPasswords: Output<Either<String, SyncKerberosPasswords>>? = null,
    public val syncNtlmPasswords: Output<Either<String, SyncNtlmPasswords>>? = null,
    public val syncOnPremPasswords: Output<Either<String, SyncOnPremPasswords>>? = null,
    public val tlsV1: Output<Either<String, TlsV1>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aad.inputs.DomainSecuritySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.aad.inputs.DomainSecuritySettingsArgs =
        com.pulumi.azurenative.aad.inputs.DomainSecuritySettingsArgs.builder()
            .channelBinding(
                channelBinding?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kerberosArmoring(
                kerberosArmoring?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .kerberosRc4Encryption(
                kerberosRc4Encryption?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .ldapSigning(
                ldapSigning?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ntlmV1(
                ntlmV1?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .syncKerberosPasswords(
                syncKerberosPasswords?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .syncNtlmPasswords(
                syncNtlmPasswords?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .syncOnPremPasswords(
                syncOnPremPasswords?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .tlsV1(
                tlsV1?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainSecuritySettingsArgs].
 */
@PulumiTagMarker
public class DomainSecuritySettingsArgsBuilder internal constructor() {
    private var channelBinding: Output<Either<String, ChannelBinding>>? = null

    private var kerberosArmoring: Output<Either<String, KerberosArmoring>>? = null

    private var kerberosRc4Encryption: Output<Either<String, KerberosRc4Encryption>>? = null

    private var ldapSigning: Output<Either<String, LdapSigning>>? = null

    private var ntlmV1: Output<Either<String, NtlmV1>>? = null

    private var syncKerberosPasswords: Output<Either<String, SyncKerberosPasswords>>? = null

    private var syncNtlmPasswords: Output<Either<String, SyncNtlmPasswords>>? = null

    private var syncOnPremPasswords: Output<Either<String, SyncOnPremPasswords>>? = null

    private var tlsV1: Output<Either<String, TlsV1>>? = null

    /**
     * @param value A flag to determine whether or not ChannelBinding is enabled or disabled.
     */
    @JvmName("ulnrspnqxvhcqtmi")
    public suspend fun channelBinding(`value`: Output<Either<String, ChannelBinding>>) {
        this.channelBinding = value
    }

    /**
     * @param value A flag to determine whether or not KerberosArmoring is enabled or disabled.
     */
    @JvmName("tfxckcesintnfxjn")
    public suspend fun kerberosArmoring(`value`: Output<Either<String, KerberosArmoring>>) {
        this.kerberosArmoring = value
    }

    /**
     * @param value A flag to determine whether or not KerberosRc4Encryption is enabled or disabled.
     */
    @JvmName("utlkceaosyydfsyf")
    public suspend fun kerberosRc4Encryption(`value`: Output<Either<String, KerberosRc4Encryption>>) {
        this.kerberosRc4Encryption = value
    }

    /**
     * @param value A flag to determine whether or not LdapSigning is enabled or disabled.
     */
    @JvmName("fnettcekaovpxafl")
    public suspend fun ldapSigning(`value`: Output<Either<String, LdapSigning>>) {
        this.ldapSigning = value
    }

    /**
     * @param value A flag to determine whether or not NtlmV1 is enabled or disabled.
     */
    @JvmName("spfyotvphshercnn")
    public suspend fun ntlmV1(`value`: Output<Either<String, NtlmV1>>) {
        this.ntlmV1 = value
    }

    /**
     * @param value A flag to determine whether or not SyncKerberosPasswords is enabled or disabled.
     */
    @JvmName("edlotmfqufhcvbrl")
    public suspend fun syncKerberosPasswords(`value`: Output<Either<String, SyncKerberosPasswords>>) {
        this.syncKerberosPasswords = value
    }

    /**
     * @param value A flag to determine whether or not SyncNtlmPasswords is enabled or disabled.
     */
    @JvmName("ahtbrmiemldgpqot")
    public suspend fun syncNtlmPasswords(`value`: Output<Either<String, SyncNtlmPasswords>>) {
        this.syncNtlmPasswords = value
    }

    /**
     * @param value A flag to determine whether or not SyncOnPremPasswords is enabled or disabled.
     */
    @JvmName("gklcdenhprrcigfo")
    public suspend fun syncOnPremPasswords(`value`: Output<Either<String, SyncOnPremPasswords>>) {
        this.syncOnPremPasswords = value
    }

    /**
     * @param value A flag to determine whether or not TlsV1 is enabled or disabled.
     */
    @JvmName("ptqbltjkidyrvorq")
    public suspend fun tlsV1(`value`: Output<Either<String, TlsV1>>) {
        this.tlsV1 = value
    }

    /**
     * @param value A flag to determine whether or not ChannelBinding is enabled or disabled.
     */
    @JvmName("yqhbhedhyisogeuv")
    public suspend fun channelBinding(`value`: Either<String, ChannelBinding>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelBinding = mapped
    }

    /**
     * @param value A flag to determine whether or not ChannelBinding is enabled or disabled.
     */
    @JvmName("jtdteiduxsolhdfh")
    public fun channelBinding(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ChannelBinding>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelBinding = mapped
    }

    /**
     * @param value A flag to determine whether or not ChannelBinding is enabled or disabled.
     */
    @JvmName("vbxwompjfmnhkfga")
    public fun channelBinding(`value`: ChannelBinding) {
        val toBeMapped = Either.ofRight<String, ChannelBinding>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelBinding = mapped
    }

    /**
     * @param value A flag to determine whether or not KerberosArmoring is enabled or disabled.
     */
    @JvmName("keqstyeduokgjjmg")
    public suspend fun kerberosArmoring(`value`: Either<String, KerberosArmoring>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberosArmoring = mapped
    }

    /**
     * @param value A flag to determine whether or not KerberosArmoring is enabled or disabled.
     */
    @JvmName("idvuwyxorbtgtbvc")
    public fun kerberosArmoring(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KerberosArmoring>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kerberosArmoring = mapped
    }

    /**
     * @param value A flag to determine whether or not KerberosArmoring is enabled or disabled.
     */
    @JvmName("atvaoqfdqmvqniet")
    public fun kerberosArmoring(`value`: KerberosArmoring) {
        val toBeMapped = Either.ofRight<String, KerberosArmoring>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kerberosArmoring = mapped
    }

    /**
     * @param value A flag to determine whether or not KerberosRc4Encryption is enabled or disabled.
     */
    @JvmName("fqgipmlbrwpjykei")
    public suspend fun kerberosRc4Encryption(`value`: Either<String, KerberosRc4Encryption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberosRc4Encryption = mapped
    }

    /**
     * @param value A flag to determine whether or not KerberosRc4Encryption is enabled or disabled.
     */
    @JvmName("yktusnikpxfoksuk")
    public fun kerberosRc4Encryption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KerberosRc4Encryption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kerberosRc4Encryption = mapped
    }

    /**
     * @param value A flag to determine whether or not KerberosRc4Encryption is enabled or disabled.
     */
    @JvmName("fllxpjywmqbjgfcv")
    public fun kerberosRc4Encryption(`value`: KerberosRc4Encryption) {
        val toBeMapped = Either.ofRight<String, KerberosRc4Encryption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kerberosRc4Encryption = mapped
    }

    /**
     * @param value A flag to determine whether or not LdapSigning is enabled or disabled.
     */
    @JvmName("vghswehchkpbbjpr")
    public suspend fun ldapSigning(`value`: Either<String, LdapSigning>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ldapSigning = mapped
    }

    /**
     * @param value A flag to determine whether or not LdapSigning is enabled or disabled.
     */
    @JvmName("vvbpvqogcegjfief")
    public fun ldapSigning(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LdapSigning>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ldapSigning = mapped
    }

    /**
     * @param value A flag to determine whether or not LdapSigning is enabled or disabled.
     */
    @JvmName("nuqavrfdyfmgadge")
    public fun ldapSigning(`value`: LdapSigning) {
        val toBeMapped = Either.ofRight<String, LdapSigning>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ldapSigning = mapped
    }

    /**
     * @param value A flag to determine whether or not NtlmV1 is enabled or disabled.
     */
    @JvmName("lgvhnauaiugewnmb")
    public suspend fun ntlmV1(`value`: Either<String, NtlmV1>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ntlmV1 = mapped
    }

    /**
     * @param value A flag to determine whether or not NtlmV1 is enabled or disabled.
     */
    @JvmName("xknwjasvmmqdxqxq")
    public fun ntlmV1(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NtlmV1>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ntlmV1 = mapped
    }

    /**
     * @param value A flag to determine whether or not NtlmV1 is enabled or disabled.
     */
    @JvmName("mvdehwbdymroicjq")
    public fun ntlmV1(`value`: NtlmV1) {
        val toBeMapped = Either.ofRight<String, NtlmV1>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ntlmV1 = mapped
    }

    /**
     * @param value A flag to determine whether or not SyncKerberosPasswords is enabled or disabled.
     */
    @JvmName("fmvqqniqsiarqynl")
    public suspend fun syncKerberosPasswords(`value`: Either<String, SyncKerberosPasswords>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncKerberosPasswords = mapped
    }

    /**
     * @param value A flag to determine whether or not SyncKerberosPasswords is enabled or disabled.
     */
    @JvmName("kyrytuiuxcyyjgoy")
    public fun syncKerberosPasswords(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SyncKerberosPasswords>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncKerberosPasswords = mapped
    }

    /**
     * @param value A flag to determine whether or not SyncKerberosPasswords is enabled or disabled.
     */
    @JvmName("tirytakkipbkmobi")
    public fun syncKerberosPasswords(`value`: SyncKerberosPasswords) {
        val toBeMapped = Either.ofRight<String, SyncKerberosPasswords>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncKerberosPasswords = mapped
    }

    /**
     * @param value A flag to determine whether or not SyncNtlmPasswords is enabled or disabled.
     */
    @JvmName("vongerbukpoijuko")
    public suspend fun syncNtlmPasswords(`value`: Either<String, SyncNtlmPasswords>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncNtlmPasswords = mapped
    }

    /**
     * @param value A flag to determine whether or not SyncNtlmPasswords is enabled or disabled.
     */
    @JvmName("hhtwscpikeyefkid")
    public fun syncNtlmPasswords(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SyncNtlmPasswords>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncNtlmPasswords = mapped
    }

    /**
     * @param value A flag to determine whether or not SyncNtlmPasswords is enabled or disabled.
     */
    @JvmName("afkgjaarkfgcskkv")
    public fun syncNtlmPasswords(`value`: SyncNtlmPasswords) {
        val toBeMapped = Either.ofRight<String, SyncNtlmPasswords>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncNtlmPasswords = mapped
    }

    /**
     * @param value A flag to determine whether or not SyncOnPremPasswords is enabled or disabled.
     */
    @JvmName("ipdfgsgpnnfrdhcb")
    public suspend fun syncOnPremPasswords(`value`: Either<String, SyncOnPremPasswords>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncOnPremPasswords = mapped
    }

    /**
     * @param value A flag to determine whether or not SyncOnPremPasswords is enabled or disabled.
     */
    @JvmName("avbdtpiqtubikdne")
    public fun syncOnPremPasswords(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SyncOnPremPasswords>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncOnPremPasswords = mapped
    }

    /**
     * @param value A flag to determine whether or not SyncOnPremPasswords is enabled or disabled.
     */
    @JvmName("tokkinkfdwndnsji")
    public fun syncOnPremPasswords(`value`: SyncOnPremPasswords) {
        val toBeMapped = Either.ofRight<String, SyncOnPremPasswords>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncOnPremPasswords = mapped
    }

    /**
     * @param value A flag to determine whether or not TlsV1 is enabled or disabled.
     */
    @JvmName("tlbvtpxbtpoqxkiq")
    public suspend fun tlsV1(`value`: Either<String, TlsV1>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsV1 = mapped
    }

    /**
     * @param value A flag to determine whether or not TlsV1 is enabled or disabled.
     */
    @JvmName("wqtjwtcbufhhfngs")
    public fun tlsV1(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TlsV1>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tlsV1 = mapped
    }

    /**
     * @param value A flag to determine whether or not TlsV1 is enabled or disabled.
     */
    @JvmName("qlyktwxkxbkcxaob")
    public fun tlsV1(`value`: TlsV1) {
        val toBeMapped = Either.ofRight<String, TlsV1>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tlsV1 = mapped
    }

    internal fun build(): DomainSecuritySettingsArgs = DomainSecuritySettingsArgs(
        channelBinding = channelBinding,
        kerberosArmoring = kerberosArmoring,
        kerberosRc4Encryption = kerberosRc4Encryption,
        ldapSigning = ldapSigning,
        ntlmV1 = ntlmV1,
        syncKerberosPasswords = syncKerberosPasswords,
        syncNtlmPasswords = syncNtlmPasswords,
        syncOnPremPasswords = syncOnPremPasswords,
        tlsV1 = tlsV1,
    )
}
