@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.inputs

import com.pulumi.azurenative.aad.inputs.ResourceForestSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Settings for Resource Forest
 * @property resourceForest Resource Forest
 * @property settings List of settings for Resource Forest
 */
public data class ResourceForestSettingsArgs(
    public val resourceForest: Output<String>? = null,
    public val settings: Output<List<ForestTrustArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aad.inputs.ResourceForestSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.aad.inputs.ResourceForestSettingsArgs =
        com.pulumi.azurenative.aad.inputs.ResourceForestSettingsArgs.builder()
            .resourceForest(resourceForest?.applyValue({ args0 -> args0 }))
            .settings(
                settings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceForestSettingsArgs].
 */
@PulumiTagMarker
public class ResourceForestSettingsArgsBuilder internal constructor() {
    private var resourceForest: Output<String>? = null

    private var settings: Output<List<ForestTrustArgs>>? = null

    /**
     * @param value Resource Forest
     */
    @JvmName("bbwddwreuxmyuutd")
    public suspend fun resourceForest(`value`: Output<String>) {
        this.resourceForest = value
    }

    /**
     * @param value List of settings for Resource Forest
     */
    @JvmName("ckyaqaqyumnsactw")
    public suspend fun settings(`value`: Output<List<ForestTrustArgs>>) {
        this.settings = value
    }

    @JvmName("hmgbnriqtqksvnvw")
    public suspend fun settings(vararg values: Output<ForestTrustArgs>) {
        this.settings = Output.all(values.asList())
    }

    /**
     * @param values List of settings for Resource Forest
     */
    @JvmName("lqdwqnxcgoujkiqj")
    public suspend fun settings(values: List<Output<ForestTrustArgs>>) {
        this.settings = Output.all(values)
    }

    /**
     * @param value Resource Forest
     */
    @JvmName("cbpueihlckdrlwev")
    public suspend fun resourceForest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceForest = mapped
    }

    /**
     * @param value List of settings for Resource Forest
     */
    @JvmName("yojkfirlampjmxnn")
    public suspend fun settings(`value`: List<ForestTrustArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument List of settings for Resource Forest
     */
    @JvmName("uiminwcqtesjvakc")
    public suspend fun settings(argument: List<suspend ForestTrustArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ForestTrustArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument List of settings for Resource Forest
     */
    @JvmName("afqjfdfefvijsgox")
    public suspend fun settings(vararg argument: suspend ForestTrustArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ForestTrustArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument List of settings for Resource Forest
     */
    @JvmName("cmopubfppxgfxcti")
    public suspend fun settings(argument: suspend ForestTrustArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ForestTrustArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param values List of settings for Resource Forest
     */
    @JvmName("uqfjfvknhluvwnkq")
    public suspend fun settings(vararg values: ForestTrustArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    internal fun build(): ResourceForestSettingsArgs = ResourceForestSettingsArgs(
        resourceForest = resourceForest,
        settings = settings,
    )
}
